/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.commands;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.commands.WRCommand;
import io.github.aquerr.worldrebuilder.entity.Region;
import io.github.aquerr.worldrebuilder.entity.SelectionPoints;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class CreateRegionCommand
extends WRCommand {
    public CreateRegionCommand(WorldRebuilder plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        String name = (String)args.requireOne((Text)Text.of((String)"name"));
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{WorldRebuilder.PLUGIN_ERROR, TextColors.RED, "Only in-game players can use this command!"}));
        }
        Player player = (Player)source;
        if (!super.getPlugin().getPlayerSelectionPoints().containsKey(player.getUniqueId())) {
            throw new CommandException(Text.of((Object[])new Object[]{WorldRebuilder.PLUGIN_ERROR, TextColors.RED, "You must select two points in the world first before creating an arena!"}));
        }
        World world = player.getWorld();
        SelectionPoints selectionPoints = super.getPlugin().getPlayerSelectionPoints().get(player.getUniqueId());
        if (selectionPoints.getFirstPoint() == null || selectionPoints.getSecondPoint() == null) {
            throw new CommandException(Text.of((Object[])new Object[]{WorldRebuilder.PLUGIN_ERROR, TextColors.RED, "You must select two points in the world first before creating an arena!"}));
        }
        if (super.getPlugin().getRegionManager().getRegion(name) != null) {
            throw new CommandException(Text.of((Object[])new Object[]{WorldRebuilder.PLUGIN_ERROR, TextColors.RED, "Region with such name already exists!"}));
        }
        Region region = new Region(name, world.getUniqueId(), selectionPoints.getFirstPoint(), selectionPoints.getSecondPoint(), 10, true);
        super.getPlugin().getRegionManager().addRegion(region);
        player.sendMessage(Text.of((Object[])new Object[]{WorldRebuilder.PLUGIN_PREFIX, TextColors.GREEN, "Region has been created!"}));
        return CommandResult.success();
    }
}

