/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.commands;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.commands.WRCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class HelpCommand
extends WRCommand {
    public HelpCommand(WorldRebuilder plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        Optional helpPage = args.getOne((Text)Text.of((String)"page"));
        int pageNumber = helpPage.orElse(1);
        Map<List<String>, CommandCallable> subcommands = super.getPlugin().getSubcommands();
        ArrayList<Text> helpList = new ArrayList<Text>();
        for (List<String> aliases : subcommands.keySet()) {
            Player player;
            CommandCallable commandCallable = subcommands.get(aliases);
            if (source instanceof Player && !commandCallable.testPermission((CommandSource)(player = (Player)source))) continue;
            Text.Builder textBuilder = Text.builder();
            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, "/wr " + String.join((CharSequence)", ", aliases) + " " + commandCallable.getUsage(source).toPlain()})});
            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.WHITE, " - " + ((Text)commandCallable.getShortDescription(source).get()).toPlain()})});
            helpList.add(textBuilder.build());
        }
        helpList.sort(Text::compareTo);
        PaginationList paginationList = PaginationList.builder().linesPerPage(16).padding(Text.of((Object[])new Object[]{TextColors.BLUE, "-"})).title(Text.of((Object[])new Object[]{TextColors.GOLD, "Commands List"})).contents(helpList).build();
        paginationList.sendTo((MessageReceiver)source, pageNumber);
        return CommandResult.success();
    }
}

