/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.commands;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.commands.WRCommand;
import io.github.aquerr.worldrebuilder.entity.Region;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class ListCommand
extends WRCommand {
    public ListCommand(WorldRebuilder plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        Collection<Region> regions = super.getPlugin().getRegionManager().getRegions();
        LinkedList<Text> helpList = new LinkedList<Text>();
        for (Region region : regions) {
            String worldName = "Not Found";
            Optional optionalWorld = Sponge.getServer().getWorld(region.getWorldUniqueId());
            if (optionalWorld.isPresent()) {
                worldName = ((World)optionalWorld.get()).getName();
            }
            Text regionTooltipInfo = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, "Name: ", TextColors.GOLD, region.getName(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, "World Name: ", TextColors.GOLD, worldName, "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, "First Point: ", TextColors.GOLD, region.getFirstPoint(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, "Second Point: ", TextColors.GOLD, region.getSecondPoint(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, "Restore Time: ", region.isActive() ? TextColors.GREEN : TextColors.RED, region.getRestoreTime(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, "Active: ", TextColors.GOLD, region.isActive()})}).build();
            Text regionRecord = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextActions.showText((Text)regionTooltipInfo), TextColors.BLUE, " - ", TextColors.GOLD, region.getName()})}).build();
            helpList.add(regionRecord);
        }
        PaginationList paginationList = PaginationList.builder().title(Text.of((Object[])new Object[]{TextColors.GOLD, "Regions List"})).contents(helpList).padding(Text.of((Object[])new Object[]{TextColors.BLUE, "-"})).build();
        paginationList.sendTo((MessageReceiver)source);
        return CommandResult.success();
    }
}

