/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.commands.args;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.entity.Region;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class RegionArgument
extends CommandElement {
    private final WorldRebuilder plugin;

    public RegionArgument(WorldRebuilder plugin, @Nullable Text key) {
        super(key);
        this.plugin = plugin;
    }

    @Nullable
    protected Region parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        Optional optionalArg = args.nextIfPresent();
        if (optionalArg.isPresent()) {
            String arg = (String)optionalArg.get();
            return this.plugin.getRegionManager().getRegion(arg);
        }
        return null;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        if (args.getAll().size() > 2) {
            return Collections.emptyList();
        }
        LinkedList<String> regionsList = new LinkedList<String>();
        Optional optionalArg = args.nextIfPresent();
        if (optionalArg.isPresent()) {
            String arg = (String)optionalArg.get();
            Collection<Region> regions = this.plugin.getRegionManager().getRegions();
            for (Region region : regions) {
                if (!region.getName().contains(arg)) continue;
                regionsList.add(region.getName());
            }
        }
        return regionsList;
    }
}

