/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.managers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github.aquerr.worldrebuilder.entity.Region;
import io.github.aquerr.worldrebuilder.storage.StorageManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

@Singleton
public class RegionManager {
    private final StorageManager storageManager;
    private final Map<String, Region> regions = new HashMap<String, Region>();

    @Inject
    public RegionManager(StorageManager storageManager) {
        this.storageManager = storageManager;
        this.loadRegions();
    }

    public Collection<Region> getRegions() {
        return this.regions.values();
    }

    public void loadRegions() {
        CompletableFuture.runAsync(() -> {
            List<Region> regions = this.storageManager.getRegions();
            for (Region region : regions) {
                this.regions.put(region.getName(), region);
            }
        });
    }

    public void addRegion(Region region) {
        CompletableFuture.runAsync(() -> this.storageManager.addRegion(region));
        this.regions.put(region.getName(), region);
    }

    public void updateRegion(Region region) {
        CompletableFuture.runAsync(() -> this.storageManager.updateRegion(region));
        this.regions.put(region.getName(), region);
    }

    public void deleteRegion(String name) {
        CompletableFuture.runAsync(() -> this.storageManager.deleteRegion(name));
        this.regions.remove(name);
    }

    @Nullable
    public Region getRegion(String name) {
        return this.regions.get(name);
    }
}

