/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.scheduling;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.world.World;

public class RebuildBlocksTask
implements Runnable {
    private final UUID worldUUID;
    private final List<BlockSnapshot> blocks;

    public RebuildBlocksTask(UUID worldUUID, List<BlockSnapshot> blocks) {
        this.worldUUID = worldUUID;
        this.blocks = blocks;
    }

    @Override
    public void run() {
        Optional optionalWorld = Sponge.getServer().getWorld(this.worldUUID);
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        for (BlockSnapshot blockSnapshot : this.blocks) {
            world.setBlock(blockSnapshot.getPosition(), blockSnapshot.getState());
        }
    }
}

