/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.api.multiblock.tier;

import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.tier.TierDescriptor;
import it.zerono.mods.zerocore.internal.ZeroCore;
import it.zerono.mods.zerocore.lib.block.properties.IPropertyValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;

public abstract class MultiblockDescriptor<Tier extends Enum<Tier>> {
    private final Class<? extends MultiblockControllerBase> _controllerClass;
    private final Class<Tier> _tierClass;
    private final EnumSet<Tier> _validTiers;
    private final EnumSet<Tier> _activeTiers;
    private final HashMap<Integer, Tier> _tierMetaMap;
    private final Tier _defaultTier;
    private final HashMap<Tier, TierDescriptor<Tier>> _tierData;
    private PropertyEnum<Tier> _tierProperty;

    @Nonnull
    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return this._controllerClass;
    }

    @Nonnull
    public MultiblockControllerBase createMultiblockController(@Nonnull World world) {
        try {
            Constructor<? extends MultiblockControllerBase> constructor = this._controllerClass.getConstructor(World.class);
            return constructor.newInstance(world);
        }
        catch (NoSuchMethodException ex) {
            ZeroCore.getLogger().error("No suitable constructor the found in Multiblock Controller class %s", (Object)this._controllerClass.getName());
            throw new RuntimeException("Multiblock Controller creation failed", ex);
        }
        catch (InstantiationException ex) {
            ZeroCore.getLogger().error("Failed to instantiate the Multiblock Controller class %s", (Object)this._controllerClass.getName());
            throw new RuntimeException("Multiblock Controller creation failed", ex);
        }
        catch (IllegalAccessException ex) {
            ZeroCore.getLogger().error("Unable to access the constructor of the Multiblock Controller class %s", (Object)this._controllerClass.getName());
            throw new RuntimeException("Multiblock Controller creation failed", ex);
        }
        catch (InvocationTargetException ex) {
            ZeroCore.getLogger().error("Error caught while constructing the Multiblock Controller class %s", (Object)this._controllerClass.getName());
            throw new RuntimeException("Multiblock Controller creation failed", ex);
        }
    }

    @Nonnull
    public TierDescriptor<Tier> getTierDescriptor(@Nonnull Tier tier) {
        TierDescriptor<Tier> descriptor = this._tierData.get(tier);
        if (null == descriptor) {
            throw new RuntimeException(String.format("No descriptor exist for tier %s", ((IStringSerializable)tier).func_176610_l()));
        }
        return descriptor;
    }

    @Nonnull
    public EnumSet<Tier> getValidTiers() {
        return this._validTiers;
    }

    @Nonnull
    public EnumSet<Tier> getActiveTiers() {
        return this._activeTiers;
    }

    @Nonnull
    public Tier getTierFromMeta(int meta) {
        Enum tier = (Enum)this._tierMetaMap.get(meta);
        return (Tier)(null != tier ? tier : this._defaultTier);
    }

    @Nonnull
    public Tier getDefaultTier() {
        return this._defaultTier;
    }

    @Nonnull
    public PropertyEnum<Tier> getTierProperty() {
        if (null == this._tierProperty) {
            throw new RuntimeException("Tier blockstate property not yet build!");
        }
        return this._tierProperty;
    }

    protected MultiblockDescriptor(@Nonnull Class<? extends MultiblockControllerBase> controllerClass, @Nonnull Tier defaultTier, @Nonnull Class<Tier> tierClass) {
        this._controllerClass = controllerClass;
        this._tierClass = tierClass;
        this._validTiers = EnumSet.noneOf(tierClass);
        this._activeTiers = EnumSet.noneOf(tierClass);
        this._tierMetaMap = new HashMap();
        this._defaultTier = defaultTier;
        this._tierData = new HashMap();
    }

    protected void addTier(boolean active, @Nonnull Tier tier) {
        this._validTiers.add(tier);
        this._tierMetaMap.put(((IPropertyValue)tier).toMeta(), tier);
        if (active) {
            this._activeTiers.add(tier);
        }
    }

    protected void buildProperties() {
        this._tierProperty = PropertyEnum.func_177707_a((String)"tier", this._tierClass, this._activeTiers);
    }

    protected void addTierDescriptor(@Nonnull TierDescriptor<Tier> descriptor) {
        this._tierData.put(descriptor.Tier, descriptor);
    }
}

