/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerOredictionificator;
import mekanism.common.network.PacketOredictionificatorGui;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiOredictionificator
extends GuiMekanismTile<TileEntityOredictionificator> {
    private Map<TileEntityOredictionificator.OredictionificatorFilter, ItemStack> renderStacks = new HashMap<TileEntityOredictionificator.OredictionificatorFilter, ItemStack>();
    private boolean isDragging = false;
    private int dragOffset = 0;
    private float scroll;

    public GuiOredictionificator(InventoryPlayer inventory, TileEntityOredictionificator tile) {
        super(tile, new ContainerOredictionificator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityOredictionificator)GuiOredictionificator.this.tileEntity).didProcess ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.LARGE_RIGHT, this, resource, 62, 118));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 25, 114));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 133, 114));
        this.field_147000_g += 64;
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 73.0f), 73), 0);
    }

    public int getFilterIndex() {
        if (((TileEntityOredictionificator)this.tileEntity).filters.size() <= 3) {
            return 0;
        }
        return (int)((float)((TileEntityOredictionificator)this.tileEntity).filters.size() * this.scroll - 3.0f / (float)((TileEntityOredictionificator)this.tileEntity).filters.size() * this.scroll);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, guiWidth + 10, guiHeight + 86, 142, 20, LangUtils.localize("gui.newFilter")));
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            Mekanism.packetHandler.sendToServer(new PacketOredictionificatorGui.OredictionificatorGuiMessage(PacketOredictionificatorGui.OredictionificatorGuiPacket.SERVER, Coord4D.get(this.tileEntity), 1, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityOredictionificator)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityOredictionificator)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        for (int i = 0; i < 3; ++i) {
            ItemStack stack;
            if (((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i) == null) continue;
            TileEntityOredictionificator.OredictionificatorFilter filter = ((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i);
            int yStart = i * 22 + 18;
            if (!this.renderStacks.containsKey(filter)) {
                this.updateRenderStacks();
            }
            if (!(stack = this.renderStacks.get(filter)).func_190926_b()) {
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                this.field_146296_j.func_180450_b(stack, 13, yStart + 3);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.filter"), 32, yStart + 2, 0x404040);
            this.renderScaledText(filter.filter, 32, yStart + 2 + 9, 0x404040, 117);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(guiWidth + 154, guiHeight + 18 + this.getScroll(), 232, 0, 12, 15);
        super.func_146976_a(partialTick, mouseX, mouseY);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        for (int i = 0; i < 3; ++i) {
            boolean mouseOver;
            if (((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i) == null) continue;
            int yStart = i * 22 + 18;
            boolean bl = mouseOver = xAxis > 10 && xAxis <= 152 && yAxis > yStart && yAxis <= yStart + 22;
            if (mouseOver) {
                MekanismRenderer.color(EnumColor.GREY, 3.0f);
            }
            this.func_73729_b(guiWidth + 10, guiHeight + yStart, 0, 230, 142, 22);
            MekanismRenderer.resetColor();
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                if (((TileEntityOredictionificator)this.tileEntity).filters.size() > 3) {
                    this.dragOffset = yAxis - (this.getScroll() + 18);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            for (int i = 0; i < 3; ++i) {
                if (((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i) == null) continue;
                int yStart = i * 22 + 18;
                if (xAxis <= 10 || xAxis > 152 || yAxis <= yStart || yAxis > yStart + 22) continue;
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketOredictionificatorGui.OredictionificatorGuiMessage(PacketOredictionificatorGui.OredictionificatorGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 1, this.getFilterIndex() + i, 0));
            }
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        if (this.isDragging) {
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 73.0f, 0.0f), 1.0f);
        }
    }

    @Override
    protected void func_146286_b(int x, int y, int type) {
        super.func_146286_b(x, y, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiOredictionificator.png");
    }

    public void updateRenderStacks() {
        this.renderStacks.clear();
        for (TileEntityOredictionificator.OredictionificatorFilter filter : ((TileEntityOredictionificator)this.tileEntity).filters) {
            if (filter.filter == null || filter.filter.isEmpty()) {
                this.renderStacks.put(filter, ItemStack.field_190927_a);
                continue;
            }
            NonNullList stacks = OreDictionary.getOres((String)filter.filter, (boolean)false);
            if (stacks.isEmpty()) {
                this.renderStacks.put(filter, ItemStack.field_190927_a);
                continue;
            }
            if (stacks.size() - 1 >= filter.index) {
                this.renderStacks.put(filter, ((ItemStack)stacks.get(filter.index)).func_77946_l());
                continue;
            }
            this.renderStacks.put(filter, ItemStack.field_190927_a);
        }
    }
}

