/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cubex2.cs4.CustomStuff4;
import cubex2.cs4.api.Content;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.LoaderPredicate;
import cubex2.cs4.data.DeserializationRegistry;
import cubex2.cs4.data.LoaderPredicateRegistry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public final class ContentLoader
implements Content {
    public String type = "contentLoader";
    public String file = "";
    String entries = null;
    public Map<String, List<String>> predicateMap = Maps.newHashMap();
    private final List<Content> contents = Lists.newArrayList();
    public static final JsonDeserializer<ContentLoader> DESERIALIZER = (json, typeOfT, context) -> {
        ContentLoader loader = new ContentLoader();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (key.equals("type")) {
                loader.type = value.getAsString();
                continue;
            }
            if (key.equals("file")) {
                loader.file = value.getAsString();
                continue;
            }
            if (key.equals("entries")) {
                loader.entries = "{ \"list\": " + value.toString() + "}";
                continue;
            }
            ArrayList predicateValues = Lists.newArrayList();
            if (value.isJsonArray()) {
                JsonArray jsonArray = value.getAsJsonArray();
                jsonArray.forEach(element -> predicateValues.add(element.getAsString()));
            } else {
                predicateValues.add(value.getAsString());
            }
            loader.predicateMap.put(key, predicateValues);
        }
        return loader;
    };

    List<Content> getContents() {
        return this.contents;
    }

    @Override
    public void init(InitPhase phase, ContentHelper helper) {
        this.contents.forEach(content -> content.init(phase, helper));
    }

    public void deserializeContent(ContentHelper helper) {
        if (this.shouldInit()) {
            String json = this.entries != null ? this.entries : helper.readJson(this.file);
            this.deserializeContent(json, helper);
        }
    }

    private void deserializeContent(@Nullable String json, ContentHelper helper) {
        Class<? extends Content> contentClass = helper.getContentClass(this.type);
        if (json != null && contentClass != null) {
            List<? extends Content> contents = ContentLoader.loadContent(json, contentClass, CustomStuff4.contentRegistry);
            this.contents.addAll(contents);
            for (Content content : this.contents) {
                if (!(content instanceof ContentLoader)) continue;
                ((ContentLoader)content).deserializeContent(helper);
            }
        }
    }

    boolean shouldInit() {
        if (this.type == null || this.file == null) {
            return false;
        }
        return this.checkPredicates(CustomStuff4.contentRegistry);
    }

    boolean checkPredicates(LoaderPredicateRegistry registry) {
        return this.predicateMap.entrySet().stream().allMatch(e -> {
            LoaderPredicate predicate = registry.getPredicate((String)e.getKey());
            return predicate != null && predicate.getResult((List)e.getValue());
        });
    }

    public static <T extends Content> List<T> loadContent(String json, Class<T> contentClass, DeserializationRegistry registry) {
        Gson gson = ContentLoader.registerAdapters(new GsonBuilder(), registry).registerTypeAdapter(new TypeToken<List<T>>(){}.getType(), ContentLoader.deserializer(contentClass)).create();
        ArrayList result = Lists.newArrayList();
        Map map = (Map)gson.fromJson(json, new TypeToken<Map<String, List<T>>>(){}.getType());
        map.values().forEach(result::addAll);
        return result;
    }

    static GsonBuilder registerAdapters(GsonBuilder builder, DeserializationRegistry registry) {
        for (Pair<Type, JsonDeserializer<?>> pair : registry.getDeserializers()) {
            builder = builder.registerTypeAdapter((Type)pair.getLeft(), pair.getRight());
        }
        return builder;
    }

    private static <T extends Content> JsonDeserializer<List<T>> deserializer(Class<T> contentClass) {
        return (json, typeOfT, context) -> {
            ArrayList result = Lists.newArrayList();
            if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    result.add(context.deserialize(array.get(i), (Type)contentClass));
                }
            } else if (json.isJsonObject()) {
                result.add(context.deserialize(json, (Type)contentClass));
            }
            return result;
        };
    }
}

