/*
 * Decompiled with CFR 0.152.
 */
package nc.render.tile;

import nc.init.NCBlocks;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.tile.TileTurbineController;
import nc.multiblock.turbine.tile.TileTurbineRotorBlade;
import nc.multiblock.turbine.tile.TileTurbineRotorShaft;
import nc.multiblock.turbine.tile.TileTurbineRotorStator;
import nc.util.NCMath;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTurbineRotor
extends TileEntitySpecialRenderer<TileTurbineController> {
    private static final Minecraft MC = Minecraft.func_71410_x();

    public boolean isGlobalRenderer(TileTurbineController tile) {
        return tile.isRenderer && tile.isMultiblockAssembled();
    }

    public void render(TileTurbineController tile, double posX, double posY, double posZ, float partialTicks, int destroyStage, float alpha) {
        TurbineRotorBladeUtil.TurbinePartDir bladeDir;
        if (!tile.isRenderer || !tile.isMultiblockAssembled()) {
            return;
        }
        Turbine turbine = (Turbine)tile.getMultiblock();
        EnumFacing dir = turbine.flowDir;
        if (dir == null) {
            return;
        }
        IBlockState shaftState = NCBlocks.turbine_rotor_shaft.func_176223_P().func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)turbine.getShaftDir()));
        boolean[] isStatorSet = new boolean[turbine.getFlowLength()];
        for (TileTurbineRotorStator stator : turbine.getRotorStators()) {
            isStatorSet[stator.getDepth()] = true;
        }
        BlockRendererDispatcher renderer = MC.func_175602_ab();
        float brightness = tile.func_145831_w().func_175724_o(turbine.getMinimumInteriorPlaneCoord(dir, turbine.getFlowLength() / 2, turbine.bladeLength - 1, turbine.bladeLength - 1));
        RenderTurbineRotor.MC.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)0.0f, (float)240.0f);
        BlockPos pos = tile.func_174877_v();
        double r = turbine.getRotorRadius();
        double rX = (double)(-turbine.getMaxX() + pos.func_177958_n()) + (dir.func_176740_k() == EnumFacing.Axis.X ? 0.0 : r);
        double rY = (double)(-turbine.getMaxY() + pos.func_177956_o()) + (dir.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : r);
        double rZ = (double)(-turbine.getMaxZ() + pos.func_177952_p()) + (dir.func_176740_k() == EnumFacing.Axis.Z ? 0.0 : r);
        double scale = r / Math.sqrt(r * r + (double)NCMath.square(turbine.shaftWidth) / 4.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(posX - rX), (double)(posY - rY), (double)(posZ - rZ));
        GlStateManager.func_179139_a((double)(dir.func_176740_k() == EnumFacing.Axis.X ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : scale));
        if (!MC.func_147113_T()) {
            turbine.rotorAngle = (turbine.rotorAngle + (float)(MC.func_71386_F() - turbine.prevRenderTime) * turbine.angVel) % 360.0f;
        }
        turbine.prevRenderTime = MC.func_71386_F();
        GlStateManager.func_179114_b((float)turbine.rotorAngle, (float)(dir.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)(dir.func_176740_k() == EnumFacing.Axis.Y ? 1.0f : 0.0f), (float)(dir.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
        GlStateManager.func_179137_b((double)((double)(-pos.func_177958_n()) + rX), (double)((double)(-pos.func_177956_o()) + rY), (double)((double)(-pos.func_177952_p()) + rZ));
        for (TileTurbineRotorShaft shaft : turbine.getRotorShafts()) {
            if (!shaft.render || isStatorSet[shaft.depth]) continue;
            GlStateManager.func_179094_E();
            pos = shaft.func_174877_v();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.func_175016_a(shaftState, brightness);
            GlStateManager.func_179121_F();
        }
        for (TileTurbineRotorBlade blade : turbine.getRotorBlades()) {
            GlStateManager.func_179094_E();
            pos = blade.bladePos();
            bladeDir = blade.getDir();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)(blade.getRenderRotation() * (dir.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ^ dir.func_176740_k() == EnumFacing.Axis.X ? 1.0f : -1.0f)), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.X ? 1.0f : 0.0f), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.Y ? 1.0f : 0.0f), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.Z ? 1.0f : 0.0f));
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.func_175016_a(blade.getRenderState(), brightness);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        pos = tile.func_174877_v();
        GlStateManager.func_179137_b((double)(posX - rX), (double)(posY - rY), (double)(posZ - rZ));
        GlStateManager.func_179139_a((double)(dir.func_176740_k() == EnumFacing.Axis.X ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : scale));
        GlStateManager.func_179137_b((double)((double)(-pos.func_177958_n()) + rX), (double)((double)(-pos.func_177956_o()) + rY), (double)((double)(-pos.func_177952_p()) + rZ));
        for (TileTurbineRotorShaft shaft : turbine.getRotorShafts()) {
            if (!isStatorSet[shaft.depth]) continue;
            GlStateManager.func_179094_E();
            pos = shaft.func_174877_v();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.func_175016_a(shaftState, brightness);
            GlStateManager.func_179121_F();
        }
        for (TileTurbineRotorStator stator : turbine.getRotorStators()) {
            GlStateManager.func_179094_E();
            pos = stator.bladePos();
            bladeDir = stator.getDir();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)(stator.getRenderRotation() * (dir.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ^ dir.func_176740_k() == EnumFacing.Axis.X ? 1.0f : -1.0f)), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.X ? 1.0f : 0.0f), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.Y ? 1.0f : 0.0f), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.Z ? 1.0f : 0.0f));
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.func_175016_a(stator.getRenderState(), brightness);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

