/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client;

import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class RenderHelpers {
    private static final Matrix4f identity = new Matrix4f();
    @SideOnly(value=Side.CLIENT)
    private static ItemModelMesher mesher;

    private RenderHelpers() {
    }

    public static void renderModel(IBakedModel model) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        renderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            RenderHelpers.renderQuads(renderer, model.func_188616_a(null, facing, 0L));
        }
        RenderHelpers.renderQuads(renderer, model.func_188616_a(null, null, 0L));
        tessellator.func_78381_a();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quad, (int)-1);
        }
    }

    public static Matrix4f getIdentity() {
        return identity;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemModelMesher getMesher() {
        ItemModelMesher mesher = RenderHelpers.mesher;
        if (mesher == null) {
            mesher = RenderHelpers.mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        }
        return mesher;
    }

    public static void loadModel(ModelBakeEvent event, String mod, String name) {
        IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation(mod, "block/" + name));
        IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(mod + ":" + name, "inventory"), (Object)bakedModel);
    }

    static {
        identity.setIdentity();
    }
}

