/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.WorldLocation;
import org.squiddev.plethora.api.method.CostHelpers;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.method.IContextFactory;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.module.BasicModuleContainer;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.core.AttachableWrapperPeripheral;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.gameplay.BlockBase;
import org.squiddev.plethora.gameplay.modules.ManipulatorType;
import org.squiddev.plethora.gameplay.modules.ModulePeripheral;
import org.squiddev.plethora.gameplay.modules.TileManipulator;
import org.squiddev.plethora.utils.MatrixHelpers;
import org.squiddev.plethora.utils.PlayerHelpers;
import org.squiddev.plethora.utils.RenderHelper;

public final class BlockManipulator
extends BlockBase<TileManipulator>
implements IPeripheralProvider {
    private static final PropertyEnum<ManipulatorType> TYPE = PropertyEnum.func_177709_a((String)"type", ManipulatorType.class);
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final double OFFSET = 0.625;
    public static final double PIX = 0.0625;
    public static final double BOX_EXPAND = 0.002;
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[6];

    public BlockManipulator() {
        super("manipulator", TileManipulator.class);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE, (Comparable)((Object)ManipulatorType.MARK_1)));
    }

    @Nonnull
    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOXES[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()];
    }

    @Nullable
    @Deprecated
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        ManipulatorType type = (ManipulatorType)((Object)blockState.func_177229_b(TYPE));
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        Vec3d startOff = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d endOff = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        AxisAlignedBB primary = this.func_185496_a(blockState, (IBlockAccess)world, pos);
        RayTraceResult result = primary.func_72327_a(startOff, endOff);
        double distance = result == null ? Double.POSITIVE_INFINITY : result.field_72307_f.func_72436_e(startOff);
        for (AxisAlignedBB child : type.boxesFor(facing)) {
            double newDistance;
            RayTraceResult hit = child.func_72327_a(startOff, endOff);
            if (hit == null || !((newDistance = hit.field_72307_f.func_72436_e(startOff)) <= distance)) continue;
            result = hit;
            distance = newDistance;
        }
        return result == null ? null : new RayTraceResult(result.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), result.field_178784_b, pos);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> itemStacks) {
        for (ManipulatorType type : ManipulatorType.VALUES) {
            itemStacks.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        ManipulatorType type = ManipulatorType.VALUES[meta & 1];
        EnumFacing facing = meta >> 1 <= 6 ? EnumFacing.field_82609_l[meta >> 1] : EnumFacing.DOWN;
        return super.func_176203_a(meta).func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((ManipulatorType)((Object)state.func_177229_b(TYPE))).ordinal() | ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal() << 1;
    }

    @Deprecated
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileManipulator) {
            ((TileManipulator)te).setOwningProfile(PlayerHelpers.getProfile((Entity)placer));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING});
    }

    @Override
    public String getTranslationKey(int meta) {
        return this.func_149739_a() + "." + ManipulatorType.VALUES[meta & 1].func_176610_l();
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileManipulator(ManipulatorType.VALUES[meta & 1]);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((ManipulatorType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        TileEntity te = world.func_175625_s(blockPos);
        if (!(te instanceof TileManipulator)) {
            return null;
        }
        final TileManipulator manipulator = (TileManipulator)te;
        if (manipulator.getType() == null) {
            return null;
        }
        final int size = manipulator.getType().size();
        final int stackHash = manipulator.getStackHash();
        final ItemStack[] stacks = new ItemStack[size];
        HashSet<ResourceLocation> modules = new HashSet<ResourceLocation>();
        HashSet<IModuleHandler> moduleHandlers = new HashSet<IModuleHandler>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation module;
            IModuleHandler moduleHandler;
            ItemStack stack = manipulator.getStack(i);
            if (stack.func_190926_b() || (moduleHandler = (IModuleHandler)(stack = (stacks[i] = stack.func_77946_l())).getCapability(Constants.MODULE_HANDLER_CAPABILITY, null)) == null || ConfigCore.Blacklist.blacklistModules.contains((module = moduleHandler.getModule()).toString())) continue;
            modules.add(module);
            moduleHandlers.add(moduleHandler);
        }
        if (modules.isEmpty()) {
            return null;
        }
        final BasicModuleContainer container = new BasicModuleContainer(modules);
        HashMap<ResourceLocation, ManipulatorAccess> accessMap = new HashMap<ResourceLocation, ManipulatorAccess>();
        ConstantReference<IModuleContainer> containerRef = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() throws LuaException {
                if (manipulator.func_145837_r()) {
                    throw new LuaException("Manipulator is no longer there");
                }
                for (int i = 0; i < size; ++i) {
                    ItemStack oldStack = stacks[i];
                    ItemStack newStack = manipulator.getStack(i);
                    if (oldStack == null || ItemStack.func_77989_b((ItemStack)stacks[i], (ItemStack)newStack)) continue;
                    IModuleHandler moduleHandler = (IModuleHandler)oldStack.getCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
                    throw new LuaException("The " + moduleHandler.getModule() + " module has been removed");
                }
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() throws LuaException {
                if (manipulator.func_145837_r()) {
                    throw new LuaException("Manipulator is no longer there");
                }
                if (stackHash != manipulator.getStackHash()) {
                    throw new LuaException("A module has changed");
                }
                return container;
            }
        };
        IContextFactory factory = ((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef).withCostHandler(CostHelpers.getCostHandler((ICapabilityProvider)manipulator))).withModules((IModuleContainer)container, containerRef)).addContext("origin", te, (IReference)Reference.tile(te))).addContext("origin", new WorldLocation(world, blockPos));
        for (IModuleHandler handler : moduleHandlers) {
            ResourceLocation module = handler.getModule();
            ManipulatorAccess access = (ManipulatorAccess)accessMap.get(module);
            if (access == null) {
                access = new ManipulatorAccess(manipulator, handler, container);
                accessMap.put(module, access);
            }
            handler.getAdditionalContext(access, (IContextBuilder)((Object)factory));
        }
        Pair<List<IMethod<?>>, List<UnbakedContext<?>>> paired = MethodRegistry.instance.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
        if (((List)paired.getLeft()).isEmpty()) {
            return null;
        }
        ModulePeripheral peripheral = new ModulePeripheral("manipulator", te, paired, manipulator.getRunner(), ((ContextFactory)factory).getAttachments(), stackHash);
        for (ManipulatorAccess access : accessMap.values()) {
            access.wrapper = peripheral;
        }
        return peripheral;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void drawHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos blockPos = event.getTarget().func_178782_a();
        IBlockState state = event.getPlayer().func_130014_f_().func_180495_p(blockPos);
        if (state.func_177230_c() != this) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Vec3d hit = event.getTarget().field_72307_f.func_178786_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        ManipulatorType type = (ManipulatorType)((Object)state.func_177229_b(TYPE));
        for (AxisAlignedBB box : type.boxesFor(facing)) {
            if (!box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(hit)) continue;
            RenderHelper.renderBoundingBox(event.getPlayer(), box, event.getTarget().func_178782_a(), event.getPartialTicks());
            event.setCanceled(true);
            break;
        }
    }

    static {
        AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockManipulator.BOXES[facing.ordinal()] = MatrixHelpers.transform(box, MatrixHelpers.matrixFor(facing));
        }
    }

    private static final class ManipulatorAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final TileManipulator tile;
        private final IWorldLocation location;
        private final ResourceLocation module;
        private final IModuleContainer container;

        private ManipulatorAccess(TileManipulator tile, IModuleHandler module, IModuleContainer container) {
            this.tile = tile;
            this.location = new WorldLocation(tile.func_145831_w(), tile.func_174877_v());
            this.module = module.getModule();
            this.container = container;
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return this.tile;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public NBTTagCompound getData() {
            return this.tile.getModuleData(this.module);
        }

        @Override
        public void markDataDirty() {
            this.tile.markModuleDataDirty();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }
}

