/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.MultiPointResizable2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class Polygon
extends ColourableObject
implements MultiPointResizable2D {
    protected final ArrayList<Vec2d> points = new ArrayList();

    protected Polygon(int id, int parent, byte type) {
        super(id, parent, type);
    }

    public Polygon(int id, int parent) {
        super(id, parent, (byte)5);
    }

    @Override
    @Nonnull
    public Vec2d getPoint(int idx) {
        return this.points.get(idx);
    }

    @Override
    public void setVertex(int idx, @Nonnull Vec2d point) {
        if (!Objects.equal((Object)this.points.get(idx), (Object)point)) {
            this.points.set(idx, point);
            this.setDirty();
        }
    }

    @Override
    public int getVertices() {
        return this.points.size();
    }

    @Override
    public void removePoint(int idx) {
        this.points.remove(idx);
        this.setDirty();
    }

    @Override
    public void addPoint(int idx, @Nonnull Vec2d point) {
        if (idx == this.points.size()) {
            this.points.add(point);
        } else {
            this.points.add(idx, point);
        }
        this.setDirty();
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        buf.writeByte(this.points.size());
        for (Vec2d point : this.points) {
            ByteBufUtils.writeVec2d(buf, point);
        }
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        int count = buf.readUnsignedByte();
        this.points.ensureCapacity(count);
        if (this.points.size() > count) {
            this.points.subList(count, this.points.size()).clear();
        }
        for (int i = 0; i < count; ++i) {
            Vec2d point = ByteBufUtils.readVec2d(buf);
            if (i < this.points.size()) {
                this.points.set(i, point);
                continue;
            }
            this.points.add(point);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        if (this.points.size() < 3) {
            return;
        }
        Polygon.setupFlat();
        int size = this.points.size();
        Vec2d a = this.points.get(0);
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        int alpha = this.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        for (int i = 1; i < size - 1; ++i) {
            Vec2d b = this.points.get(i);
            Vec2d c = this.points.get(i + 1);
            buffer.func_181662_b(a.x, a.y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(b.x, b.y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(c.x, c.y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }
}

