/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.chickens;

import com.setycz.chickens.config.ConfigHandler;
import com.setycz.chickens.entity.EntityChickensChicken;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.method.ContextHelpers;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.integration.chickens.IntegrationChickens;
import org.squiddev.plethora.utils.WorldDummy;

@Injects(value="chickens")
public final class MetaChickens {
    public static final IMetaProvider<EntityChickensChicken> META_ENTITY_CHICKEN = new BaseMetaProvider<EntityChickensChicken>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<EntityChickensChicken> context) {
            HashMap<String, Object> out = new HashMap<String, Object>();
            EntityChickensChicken chicken = context.getTarget();
            out.put("analyzed", chicken.getStatsAnalyzed());
            out.put("tier", chicken.getTier());
            if (ConfigHandler.alwaysShowStats || chicken.getStatsAnalyzed() || context.getModules().hasModule(IntegrationChickens.ANALYZER_MOD)) {
                out.put("growth", chicken.getGrowth());
                out.put("gain", chicken.getGain());
                out.put("strength", chicken.getStrength());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            chicken.func_70014_b(nbt);
            String chickenType = nbt.func_74779_i("Type");
            out.put("type", chickenType);
            ChickensRegistryItem chickenDesc = ChickensRegistry.getByRegistryName((String)chickenType);
            if (chickenDesc != null) {
                out.put("layItem", ContextHelpers.wrapStack(context, chickenDesc.createLayItem()));
                out.put("dropItem", ContextHelpers.wrapStack(context, chickenDesc.createDropItem()));
            }
            return Collections.singletonMap("chickens", out);
        }

        @Override
        @Nonnull
        public EntityChickensChicken getExample() {
            EntityChickensChicken chicken = new EntityChickensChicken((World)WorldDummy.INSTANCE);
            chicken.setChickenType(ChickensRegistry.SMART_CHICKEN_ID.toString());
            return chicken;
        }
    };
    public static final IMetaProvider<ChickensRegistryItem> META_CHICKENS_REGISTRY_ITEM = new BaseMetaProvider<ChickensRegistryItem>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<ChickensRegistryItem> context) {
            HashMap<String, Object> out = new HashMap<String, Object>();
            ChickensRegistryItem chicken = context.getTarget();
            out.put("type", chicken.getRegistryName().toString());
            out.put("layItem", ContextHelpers.wrapStack(context, chicken.createLayItem()));
            out.put("dropItem", ContextHelpers.wrapStack(context, chicken.createDropItem()));
            out.put("tier", chicken.getTier());
            ChickensRegistryItem parent1 = chicken.getParent1();
            out.put("parent1", parent1 == null ? null : parent1.getRegistryName().toString());
            ChickensRegistryItem parent2 = chicken.getParent2();
            out.put("parent2", parent2 == null ? null : parent2.getRegistryName().toString());
            return out;
        }

        @Override
        @Nullable
        public ChickensRegistryItem getExample() {
            return ChickensRegistry.getSmartChicken();
        }
    };

    private MetaChickens() {
    }
}

