/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class IngredientEnchanted
extends Ingredient {
    private final Enchantment enchantment;
    private final int minLevel;
    private ItemStack[] stacks;
    private IntList packed;

    IngredientEnchanted(Enchantment enchantment, int minLevel) {
        super(new ItemStack[0]);
        this.enchantment = enchantment;
        this.minLevel = minLevel;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.stacks != null) {
            return this.stacks;
        }
        if (this.enchantment.field_77351_y == null) {
            this.stacks = new ItemStack[0];
            return this.stacks;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : Item.field_150901_e) {
            if (this.enchantment.field_77351_y == null || !this.enchantment.field_77351_y.func_77557_a(item)) continue;
            for (int level = this.minLevel; level <= this.enchantment.func_77325_b(); ++level) {
                ItemStack stack = new ItemStack(item);
                EnchantmentHelper.func_82782_a(Collections.singletonMap(this.enchantment, level), (ItemStack)stack);
                stacks.add(stack);
            }
        }
        this.stacks = stacks.toArray(new ItemStack[0]);
        return this.stacks;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.packed != null) {
            return this.packed;
        }
        this.packed = new IntArrayList();
        for (ItemStack stack : this.func_193365_a()) {
            this.packed.add(RecipeItemHelper.func_194113_b((ItemStack)stack));
        }
        this.packed.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        return this.packed;
    }

    public boolean apply(@Nullable ItemStack target) {
        if (target == null || target.func_190926_b()) {
            return false;
        }
        NBTTagList enchantments = target.func_77973_b() == Items.field_151134_bR ? ItemEnchantedBook.func_92110_g((ItemStack)target) : target.func_77986_q();
        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
            NBTTagCompound tag = enchantments.func_150305_b(i);
            Enchantment itemEnchant = Enchantment.func_185262_c((int)tag.func_74765_d("id"));
            if (itemEnchant != this.enchantment) continue;
            return tag.func_74765_d("lvl") >= this.minLevel;
        }
        return false;
    }

    protected void invalidate() {
        this.stacks = null;
        this.packed = null;
    }

    public boolean isSimple() {
        return false;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            ResourceLocation enchantmentId = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"id"));
            int level = JsonUtils.func_151208_a((JsonObject)json, (String)"level", (int)1);
            if (!Enchantment.field_185264_b.func_148741_d((Object)enchantmentId)) {
                throw new JsonSyntaxException("Unknown enchantment '" + enchantmentId + "'");
            }
            Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)enchantmentId);
            return new IngredientEnchanted(enchantment, level);
        }
    }
}

