/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.FluxNetworks;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketColorCache
implements IMessageHandler<ColorCacheMessage, IMessage> {
    public IMessage onMessage(ColorCacheMessage message, MessageContext ctx) {
        FluxNetworks.proxy.receiveColorCache(message.cache);
        return null;
    }

    public static class ColorCacheMessage
    implements IMessage {
        public Map<Integer, Tuple<Integer, String>> cache;

        public ColorCacheMessage() {
        }

        public ColorCacheMessage(Map<Integer, Tuple<Integer, String>> cache) {
            this.cache = cache;
        }

        public void fromBytes(ByteBuf buf) {
            this.cache = new HashMap<Integer, Tuple<Integer, String>>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                int id = buf.readInt();
                int colour = buf.readInt();
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.cache.put(id, (Tuple<Integer, String>)new Tuple((Object)colour, (Object)name));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.cache.size());
            this.cache.forEach((ID, DETAILS) -> {
                buf.writeInt(ID.intValue());
                buf.writeInt(((Integer)DETAILS.func_76341_a()).intValue());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)DETAILS.func_76340_b()));
            });
        }
    }
}

