/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.caching;

import java.util.Objects;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MetaContexts {
    private final Contexts contexts;
    private final MetaStackDefinition prefixStackDefinition;
    private final MetaStackDefinition suffixStackDefinition;
    private final int hashCode;

    public static MetaContexts of(@NonNull Contexts contexts, @NonNull MetaStackDefinition prefixStackDefinition, @NonNull MetaStackDefinition suffixStackDefinition) {
        return new MetaContexts(contexts, prefixStackDefinition, suffixStackDefinition);
    }

    public MetaContexts(@NonNull Contexts contexts, @NonNull MetaStackDefinition prefixStackDefinition, @NonNull MetaStackDefinition suffixStackDefinition) {
        this.contexts = Objects.requireNonNull(contexts, "contexts");
        this.prefixStackDefinition = Objects.requireNonNull(prefixStackDefinition, "prefixStackDefinition");
        this.suffixStackDefinition = Objects.requireNonNull(suffixStackDefinition, "suffixStackDefinition");
        this.hashCode = this.calculateHashCode();
    }

    public @NonNull Contexts getContexts() {
        return this.contexts;
    }

    public @NonNull MetaStackDefinition getPrefixStackDefinition() {
        return this.prefixStackDefinition;
    }

    public @NonNull MetaStackDefinition getSuffixStackDefinition() {
        return this.suffixStackDefinition;
    }

    public @NonNull String toString() {
        return "MetaContexts(contexts=" + this.getContexts() + ", prefixStackDefinition=" + this.getPrefixStackDefinition() + ", suffixStackDefinition=" + this.getSuffixStackDefinition() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaContexts)) {
            return false;
        }
        MetaContexts that = (MetaContexts)o;
        return this.contexts.equals(that.contexts) && this.prefixStackDefinition.equals(that.prefixStackDefinition) && this.suffixStackDefinition.equals(that.suffixStackDefinition);
    }

    private int calculateHashCode() {
        return Objects.hash(this.contexts, this.prefixStackDefinition, this.suffixStackDefinition);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

