/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.lucko.luckperms.api.messenger.IncomingMessageConsumer;
import me.lucko.luckperms.api.messenger.Messenger;
import me.lucko.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractSqlMessenger
implements Messenger {
    private final IncomingMessageConsumer consumer;
    private long lastId = -1L;

    protected AbstractSqlMessenger(IncomingMessageConsumer consumer) {
        this.consumer = consumer;
    }

    protected abstract Connection getConnection() throws SQLException;

    protected abstract String getTableName();

    public void init() throws SQLException {
        try (Connection c = this.getConnection();){
            try (PreparedStatement ps = c.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.getTableName() + "` (`id` INT AUTO_INCREMENT NOT NULL, `time` TIMESTAMP NOT NULL, `msg` TEXT NOT NULL, PRIMARY KEY (`id`))");){
                ps.execute();
            }
            ps = c.prepareStatement("SELECT MAX(`id`) as `latest` FROM `" + this.getTableName() + "`");
            var4_6 = null;
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    this.lastId = rs.getLong("latest");
                }
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var4_6 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
    }

    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        try (Connection c = this.getConnection();
             PreparedStatement ps = c.prepareStatement("INSERT INTO " + this.getTableName() + "(`time`, `msg`) VALUES(NOW(), ?)");){
            ps.setString(1, outgoingMessage.asEncodedString());
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void pollMessages() {
        try (Connection c = this.getConnection();
             PreparedStatement ps = c.prepareStatement("SELECT `id`, `msg` FROM " + this.getTableName() + " WHERE `id` > ? AND (NOW() - `time` < 30)");){
            ps.setLong(1, this.lastId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("id");
                    this.lastId = Math.max(this.lastId, id);
                    String message = rs.getString("msg");
                    this.consumer.consumeIncomingMessageAsString(message);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void runHousekeeping() {
        try (Connection c = this.getConnection();
             PreparedStatement ps = c.prepareStatement("DELETE FROM " + this.getTableName() + " WHERE (NOW() - `time` > 60)");){
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

