/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.NodeEqualityPredicate;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.TemporaryDataMutateResult;
import me.lucko.luckperms.api.TemporaryMergeBehaviour;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.caching.HolderCachedData;
import me.lucko.luckperms.common.caching.type.MetaAccumulator;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.inheritance.InheritanceComparator;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.NodeMap;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.node.utils.InheritanceInfo;
import me.lucko.luckperms.common.node.utils.MetaType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class PermissionHolder {
    private final LuckPermsPlugin plugin;
    private final NodeMap enduringNodes = new NodeMap(this);
    private final NodeMap transientNodes = new NodeMap(this);
    private final Lock ioLock = new ReentrantLock();
    private final Comparator<Group> inheritanceComparator = InheritanceComparator.getFor(this);

    protected PermissionHolder(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public Lock getIoLock() {
        return this.ioLock;
    }

    public Comparator<Group> getInheritanceComparator() {
        return this.inheritanceComparator;
    }

    public NodeMap getData(NodeMapType type) {
        switch (type) {
            case ENDURING: {
                return this.enduringNodes;
            }
            case TRANSIENT: {
                return this.transientNodes;
            }
        }
        throw new AssertionError();
    }

    public NodeMap enduringData() {
        return this.enduringNodes;
    }

    public NodeMap transientData() {
        return this.transientNodes;
    }

    public abstract String getObjectName();

    public abstract String getFormattedDisplayName();

    public abstract String getPlainDisplayName();

    public abstract HolderCachedData<?> getCachedData();

    public abstract HolderType getType();

    public void invalidateCachedData() {
        this.getCachedData().invalidate();
    }

    protected void invalidateCache() {
        this.enduringNodes.invalidate();
        this.transientNodes.invalidate();
        this.invalidateCachedData();
        this.getPlugin().getEventFactory().handleDataRecalculate(this);
    }

    public void setNodes(NodeMapType type, Set<? extends Node> set) {
        this.getData(type).setContent(set);
        this.invalidateCache();
    }

    public void replaceNodes(NodeMapType type, Multimap<ImmutableContextSet, ? extends Node> multimap) {
        this.getData(type).setContent(multimap);
        this.invalidateCache();
    }

    public List<LocalizedNode> getOwnNodes() {
        ArrayList<LocalizedNode> ret = new ArrayList<LocalizedNode>();
        this.transientNodes.copyTo(ret);
        this.enduringNodes.copyTo(ret);
        return ret;
    }

    public List<LocalizedNode> getOwnNodes(ContextSet filter) {
        ArrayList<LocalizedNode> ret = new ArrayList<LocalizedNode>();
        this.transientNodes.copyTo(ret, filter);
        this.enduringNodes.copyTo(ret, filter);
        return ret;
    }

    public List<LocalizedNode> getOwnGroupNodes() {
        ArrayList<LocalizedNode> ret = new ArrayList<LocalizedNode>();
        this.transientNodes.copyGroupNodesTo(ret);
        this.enduringNodes.copyGroupNodesTo(ret);
        return ret;
    }

    public List<LocalizedNode> getOwnGroupNodes(ContextSet filter) {
        ArrayList<LocalizedNode> ret = new ArrayList<LocalizedNode>();
        this.transientNodes.copyGroupNodesTo(ret, filter);
        this.enduringNodes.copyGroupNodesTo(ret, filter);
        return ret;
    }

    public SortedSet<LocalizedNode> getOwnNodesSorted() {
        TreeSet<? super Node> ret = new TreeSet<Node>(NodeWithContextComparator.reverse());
        this.transientNodes.copyTo(ret);
        this.enduringNodes.copyTo(ret);
        return ret;
    }

    public boolean removeIf(Predicate<? super LocalizedNode> predicate) {
        return this.removeIf(predicate, null);
    }

    public boolean removeIf(Predicate<? super LocalizedNode> predicate, Runnable taskIfSuccess) {
        ImmutableCollection before = this.enduringData().immutable().values();
        if (!this.enduringNodes.removeIf(predicate)) {
            return false;
        }
        if (taskIfSuccess != null) {
            taskIfSuccess.run();
        }
        this.invalidateCache();
        ImmutableCollection after = this.enduringData().immutable().values();
        this.plugin.getEventFactory().handleNodeClear(this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return true;
    }

    public boolean removeIf(ContextSet contextSet, Predicate<? super LocalizedNode> predicate) {
        return this.removeIf(contextSet, predicate, null);
    }

    public boolean removeIf(ContextSet contextSet, Predicate<? super LocalizedNode> predicate, Runnable taskIfSuccess) {
        ImmutableCollection before = this.enduringData().immutable().values();
        if (!this.enduringNodes.removeIf(contextSet, predicate)) {
            return false;
        }
        if (taskIfSuccess != null) {
            taskIfSuccess.run();
        }
        this.invalidateCache();
        ImmutableCollection after = this.enduringData().immutable().values();
        this.plugin.getEventFactory().handleNodeClear(this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return true;
    }

    public boolean removeIfTransient(Predicate<? super LocalizedNode> predicate) {
        boolean result = this.transientNodes.removeIf(predicate);
        if (result) {
            this.invalidateCache();
        }
        return result;
    }

    public void accumulateInheritancesTo(List<? super LocalizedNode> accumulator, Contexts context) {
        InheritanceGraph graph = this.plugin.getInheritanceHandler().getGraph(context);
        Iterable<PermissionHolder> traversal = graph.traverse(this.plugin.getConfiguration().get(ConfigKeys.INHERITANCE_TRAVERSAL_ALGORITHM), this);
        for (PermissionHolder holder : traversal) {
            List<LocalizedNode> nodes = holder.getOwnNodes(context.getContexts());
            accumulator.addAll(nodes);
        }
    }

    public List<LocalizedNode> resolveInheritances(Contexts context) {
        ArrayList<LocalizedNode> accumulator = new ArrayList<LocalizedNode>();
        this.accumulateInheritancesTo(accumulator, context);
        return accumulator;
    }

    public void accumulateInheritancesTo(List<? super LocalizedNode> accumulator) {
        InheritanceGraph graph = this.plugin.getInheritanceHandler().getGraph();
        Iterable<PermissionHolder> traversal = graph.traverse(this.plugin.getConfiguration().get(ConfigKeys.INHERITANCE_TRAVERSAL_ALGORITHM), this);
        for (PermissionHolder holder : traversal) {
            List<LocalizedNode> nodes = holder.getOwnNodes();
            accumulator.addAll(nodes);
        }
    }

    public List<LocalizedNode> resolveInheritances() {
        ArrayList<LocalizedNode> accumulator = new ArrayList<LocalizedNode>();
        this.accumulateInheritancesTo(accumulator);
        return accumulator;
    }

    public List<LocalizedNode> getAllEntries(Contexts context) {
        LinkedList<LocalizedNode> entries = new LinkedList<LocalizedNode>();
        if (context.hasSetting(LookupSetting.RESOLVE_INHERITANCE)) {
            this.accumulateInheritancesTo(entries, context);
        } else {
            entries.addAll(this.getOwnNodes(context.getContexts()));
        }
        if (!context.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER)) {
            entries.removeIf((? super E n) -> !n.isGroupNode() && !n.isServerSpecific());
        }
        if (!context.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD)) {
            entries.removeIf((? super E n) -> !n.isGroupNode() && !n.isWorldSpecific());
        }
        return entries;
    }

    public Map<String, Boolean> exportPermissions(Contexts context, boolean convertToLowercase, boolean resolveShorthand) {
        List<LocalizedNode> entries = this.getAllEntries(context);
        return PermissionHolder.processExportedPermissions(entries, convertToLowercase, resolveShorthand);
    }

    public Map<String, Boolean> exportPermissions(boolean convertToLowercase, boolean resolveShorthand) {
        List<LocalizedNode> entries = this.resolveInheritances();
        return PermissionHolder.processExportedPermissions(entries, convertToLowercase, resolveShorthand);
    }

    private static ImmutableMap<String, Boolean> processExportedPermissions(List<LocalizedNode> entries, boolean convertToLowercase, boolean resolveShorthand) {
        HashMap<String, Boolean> perms = new HashMap<String, Boolean>(entries.size());
        for (Node node : entries) {
            if (convertToLowercase) {
                perms.putIfAbsent(node.getPermission().toLowerCase(), node.getValue());
                continue;
            }
            perms.putIfAbsent(node.getPermission(), node.getValue());
        }
        if (resolveShorthand) {
            for (Node node : entries) {
                List<String> shorthand = node.resolveShorthand();
                for (String s : shorthand) {
                    if (convertToLowercase) {
                        perms.putIfAbsent(s.toLowerCase(), node.getValue());
                        continue;
                    }
                    perms.putIfAbsent(s, node.getValue());
                }
            }
        }
        return ImmutableMap.copyOf(perms);
    }

    public MetaAccumulator accumulateMeta(MetaAccumulator accumulator, Contexts context) {
        if (accumulator == null) {
            accumulator = MetaAccumulator.makeFromConfig(this.plugin);
        }
        InheritanceGraph graph = this.plugin.getInheritanceHandler().getGraph(context);
        Iterable<PermissionHolder> traversal = graph.traverse(this.plugin.getConfiguration().get(ConfigKeys.INHERITANCE_TRAVERSAL_ALGORITHM), this);
        for (PermissionHolder holder : traversal) {
            List<LocalizedNode> nodes = holder.getOwnNodes(context.getContexts());
            for (LocalizedNode node : nodes) {
                if (!node.getValue() || !node.isMeta() && !node.isPrefix() && !node.isSuffix() || !context.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER) && !node.isServerSpecific() || !context.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD) && !node.isWorldSpecific()) continue;
                accumulator.accumulateNode(node);
            }
            OptionalInt w = holder.getWeight();
            if (!w.isPresent()) continue;
            accumulator.accumulateWeight(w.getAsInt());
        }
        return accumulator;
    }

    public MetaAccumulator accumulateMeta(MetaAccumulator accumulator) {
        if (accumulator == null) {
            accumulator = MetaAccumulator.makeFromConfig(this.plugin);
        }
        InheritanceGraph graph = this.plugin.getInheritanceHandler().getGraph();
        Iterable<PermissionHolder> traversal = graph.traverse(this.plugin.getConfiguration().get(ConfigKeys.INHERITANCE_TRAVERSAL_ALGORITHM), this);
        for (PermissionHolder holder : traversal) {
            List<LocalizedNode> nodes = holder.getOwnNodes();
            for (LocalizedNode node : nodes) {
                if (!node.getValue() || !node.isMeta() && !node.isPrefix() && !node.isSuffix()) continue;
                accumulator.accumulateNode(node);
            }
            OptionalInt w = this.getWeight();
            if (!w.isPresent()) continue;
            accumulator.accumulateWeight(w.getAsInt());
        }
        return accumulator;
    }

    public boolean auditTemporaryPermissions() {
        boolean transientWork = this.transientNodes.auditTemporaryNodes(null);
        ImmutableCollection before = this.enduringData().immutable().values();
        HashSet removed = new HashSet();
        boolean enduringWork = this.enduringNodes.auditTemporaryNodes(removed);
        if (enduringWork) {
            this.invalidateCache();
            ImmutableCollection after = this.enduringData().immutable().values();
            for (Node r : removed) {
                this.plugin.getEventFactory().handleNodeRemove(r, this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
            }
        }
        if (transientWork && !enduringWork) {
            this.invalidateCache();
        }
        return transientWork || enduringWork;
    }

    private Optional<LocalizedNode> searchForMatch(NodeMapType type, Node node, NodeEqualityPredicate equalityPredicate) {
        for (LocalizedNode n : this.getData(type).immutable().values()) {
            if (!n.equals(node, equalityPredicate)) continue;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    public Tristate hasPermission(NodeMapType type, Node node, NodeEqualityPredicate equalityPredicate) {
        if (this.getType().isGroup() && node.isGroupNode() && node.getGroupName().equalsIgnoreCase(this.getObjectName())) {
            return Tristate.TRUE;
        }
        return this.searchForMatch(type, node, equalityPredicate).map(Node::getTristate).orElse(Tristate.UNDEFINED);
    }

    public InheritanceInfo searchForInheritedMatch(Node node, NodeEqualityPredicate equalityPredicate) {
        for (LocalizedNode n : this.resolveInheritances()) {
            if (!n.getNode().equals(node, equalityPredicate)) continue;
            return InheritanceInfo.of(n);
        }
        return InheritanceInfo.empty();
    }

    public Tristate inheritsPermission(Node node, NodeEqualityPredicate equalityPredicate) {
        return this.searchForInheritedMatch(node, equalityPredicate).getResult();
    }

    public DataMutateResult setPermission(Node node) {
        return this.setPermission(node, true);
    }

    public DataMutateResult setPermission(Node node, boolean callEvent) {
        if (this.hasPermission(NodeMapType.ENDURING, node, StandardNodeEquality.IGNORE_EXPIRY_TIME) != Tristate.UNDEFINED) {
            return DataMutateResult.ALREADY_HAS;
        }
        ImmutableCollection before = this.enduringData().immutable().values();
        this.enduringNodes.add(node);
        this.invalidateCache();
        ImmutableCollection after = this.enduringData().immutable().values();
        if (callEvent) {
            this.plugin.getEventFactory().handleNodeAdd(node, this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        }
        return DataMutateResult.SUCCESS;
    }

    public TemporaryDataMutateResult setPermission(Node node, TemporaryMergeBehaviour modifier) {
        TemporaryDataMutateResult result = this.handleTemporaryMergeBehaviour(NodeMapType.ENDURING, node, modifier);
        if (result != null) {
            return result;
        }
        return new TemporaryResult(this.setPermission(node), node);
    }

    public DataMutateResult setTransientPermission(Node node) {
        if (this.hasPermission(NodeMapType.TRANSIENT, node, StandardNodeEquality.IGNORE_EXPIRY_TIME) != Tristate.UNDEFINED) {
            return DataMutateResult.ALREADY_HAS;
        }
        this.transientNodes.add(node);
        this.invalidateCache();
        return DataMutateResult.SUCCESS;
    }

    public TemporaryDataMutateResult setTransientPermission(Node node, TemporaryMergeBehaviour modifier) {
        TemporaryDataMutateResult result = this.handleTemporaryMergeBehaviour(NodeMapType.TRANSIENT, node, modifier);
        if (result != null) {
            return result;
        }
        return new TemporaryResult(this.setTransientPermission(node), node);
    }

    private TemporaryDataMutateResult handleTemporaryMergeBehaviour(NodeMapType nodeMapType, Node node, TemporaryMergeBehaviour mergeBehaviour) {
        if (!node.isTemporary() || mergeBehaviour == TemporaryMergeBehaviour.FAIL_WITH_ALREADY_HAS) {
            return null;
        }
        Node previous = this.searchForMatch(nodeMapType, node, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE).orElse(null);
        if (previous == null) {
            return null;
        }
        NodeMap data = this.getData(nodeMapType);
        boolean callEvents = nodeMapType == NodeMapType.ENDURING;
        switch (mergeBehaviour) {
            case ADD_NEW_DURATION_TO_EXISTING: {
                Node newNode = node.toBuilder().setExpiry(previous.getExpiryUnixTime() + node.getSecondsTilExpiry()).build();
                ImmutableCollection before = null;
                if (callEvents) {
                    before = data.immutable().values();
                }
                data.replace(newNode, previous);
                this.invalidateCache();
                if (callEvents) {
                    ImmutableCollection after = data.immutable().values();
                    this.plugin.getEventFactory().handleNodeAdd(newNode, this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
                }
                return new TemporaryResult(DataMutateResult.SUCCESS, newNode);
            }
            case REPLACE_EXISTING_IF_DURATION_LONGER: {
                if (node.getExpiryUnixTime() <= previous.getExpiryUnixTime()) break;
                ImmutableCollection before = null;
                if (callEvents) {
                    before = data.immutable().values();
                }
                data.replace(node, previous);
                this.invalidateCache();
                if (callEvents) {
                    ImmutableCollection after = data.immutable().values();
                    this.plugin.getEventFactory().handleNodeAdd(node, this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
                }
                return new TemporaryResult(DataMutateResult.SUCCESS, node);
            }
        }
        return null;
    }

    public DataMutateResult unsetPermission(Node node) {
        if (this.hasPermission(NodeMapType.ENDURING, node, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE) == Tristate.UNDEFINED) {
            return DataMutateResult.LACKS;
        }
        ImmutableCollection before = this.enduringData().immutable().values();
        this.enduringNodes.remove(node);
        this.invalidateCache();
        ImmutableCollection after = this.enduringData().immutable().values();
        this.plugin.getEventFactory().handleNodeRemove(node, this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return DataMutateResult.SUCCESS;
    }

    public DataMutateResult unsetTransientPermission(Node node) {
        if (this.hasPermission(NodeMapType.TRANSIENT, node, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE) == Tristate.UNDEFINED) {
            return DataMutateResult.LACKS;
        }
        this.transientNodes.remove(node);
        this.invalidateCache();
        return DataMutateResult.SUCCESS;
    }

    public boolean clearNodes() {
        ImmutableCollection before = this.enduringData().immutable().values();
        this.enduringNodes.clear();
        this.invalidateCache();
        ImmutableCollection after = this.enduringData().immutable().values();
        if (before.size() == after.size()) {
            return false;
        }
        this.plugin.getEventFactory().handleNodeClear(this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return true;
    }

    public boolean clearNodes(ContextSet contextSet) {
        ImmutableCollection before = this.enduringData().immutable().values();
        this.enduringNodes.clear(contextSet);
        this.invalidateCache();
        ImmutableCollection after = this.enduringData().immutable().values();
        if (before.size() == after.size()) {
            return false;
        }
        this.plugin.getEventFactory().handleNodeClear(this, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return true;
    }

    public boolean clearPermissions() {
        return this.removeIf(node -> !node.hasTypeData());
    }

    public boolean clearPermissions(ContextSet contextSet) {
        return this.removeIf(contextSet, (? super LocalizedNode node) -> !node.hasTypeData());
    }

    public boolean clearParents(boolean giveDefault) {
        return this.removeIf(Node::isGroupNode, () -> {
            if (this.getType().isUser() && giveDefault) {
                this.plugin.getUserManager().giveDefaultIfNeeded((User)this, false);
            }
        });
    }

    public boolean clearParents(ContextSet contextSet, boolean giveDefault) {
        return this.removeIf(contextSet, Node::isGroupNode, () -> {
            if (this.getType().isUser() && giveDefault) {
                this.plugin.getUserManager().giveDefaultIfNeeded((User)this, false);
            }
        });
    }

    public boolean clearMeta(MetaType type) {
        return this.removeIf(type::matches);
    }

    public boolean clearMeta(MetaType type, ContextSet contextSet) {
        return this.removeIf(contextSet, type::matches);
    }

    public boolean clearMetaKeys(String key, boolean temp) {
        return this.removeIf(n -> n.isMeta() && n.isTemporary() == temp && n.getMeta().getKey().equalsIgnoreCase(key));
    }

    public boolean clearMetaKeys(String key, ContextSet contextSet, boolean temp) {
        return this.removeIf(contextSet, (? super LocalizedNode n) -> n.isMeta() && n.isTemporary() == temp && n.getMeta().getKey().equalsIgnoreCase(key));
    }

    public boolean clearTransientNodes() {
        this.transientNodes.clear();
        this.invalidateCache();
        return true;
    }

    public OptionalInt getWeight() {
        return OptionalInt.empty();
    }

    private static final class TemporaryResult
    implements TemporaryDataMutateResult {
        private final DataMutateResult result;
        private final Node mergedNode;

        private TemporaryResult(DataMutateResult result, Node mergedNode) {
            this.result = result;
            this.mergedNode = mergedNode;
        }

        @Override
        public @NonNull DataMutateResult getResult() {
            return this.result;
        }

        @Override
        public @NonNull Node getMergedNode() {
            return this.mergedNode;
        }
    }
}

