/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import java.util.HashSet;
import java.util.Set;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.sender.Sender;

public class ProgressLogger {
    private static final int NOTIFY_FREQUENCY = 500;
    private final String pluginName;
    private final Message logMessage;
    private final Message logProgressMessage;
    private final Set<Sender> listeners = new HashSet<Sender>();

    public ProgressLogger(String pluginName) {
        this(pluginName, Message.MIGRATION_LOG, Message.MIGRATION_LOG_PROGRESS);
    }

    public ProgressLogger(String pluginName, Message logMessage, Message logProgressMessage) {
        this.pluginName = pluginName;
        this.logMessage = logMessage;
        this.logProgressMessage = logProgressMessage;
    }

    public void addListener(Sender sender) {
        this.listeners.add(sender);
    }

    public void log(String msg) {
        if (this.pluginName == null) {
            this.listeners.forEach(s -> this.logMessage.send((Sender)s, msg));
        } else {
            this.listeners.forEach(s -> this.logMessage.send((Sender)s, this.pluginName, msg));
        }
    }

    public void logError(String msg) {
        if (this.pluginName == null) {
            this.listeners.forEach(s -> this.logMessage.send((Sender)s, "Error -> " + msg));
        } else {
            this.listeners.forEach(s -> this.logMessage.send((Sender)s, this.pluginName, "Error -> " + msg));
        }
    }

    public void logAllProgress(String msg, int amount) {
        if (this.pluginName == null) {
            this.listeners.forEach(s -> this.logProgressMessage.send((Sender)s, msg.replace("{}", Integer.toString(amount))));
        } else {
            this.listeners.forEach(s -> this.logProgressMessage.send((Sender)s, this.pluginName, msg.replace("{}", Integer.toString(amount))));
        }
    }

    public void logProgress(String msg, int amount) {
        if (amount % 500 == 0) {
            this.logAllProgress(msg, amount);
        }
    }

    public Set<Sender> getListeners() {
        return this.listeners;
    }
}

