/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.serializer.ComponentSerializers;

public final class TextUtils {
    public static String joinNewline(String ... strings) {
        return TextUtils.joinNewline(Arrays.stream(strings));
    }

    public static String joinNewline(Stream<String> strings) {
        return strings.collect(Collectors.joining("\n"));
    }

    public static TextComponent fromLegacy(String input, char character) {
        return ComponentSerializers.LEGACY.deserialize(input, character);
    }

    public static TextComponent fromLegacy(String input) {
        return ComponentSerializers.LEGACY.deserialize(input);
    }

    public static String toLegacy(Component component, char character) {
        return ComponentSerializers.LEGACY.serialize(component, character);
    }

    public static String toLegacy(Component component) {
        return ComponentSerializers.LEGACY.serialize(component);
    }

    public static String rewritePlaceholders(String input) {
        int i = 0;
        while (input.contains("{}")) {
            input = input.replaceFirst("\\{\\}", "{" + i++ + "}");
        }
        return input;
    }

    private TextUtils() {
    }
}

