/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.web;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.utils.gson.GsonProvider;
import me.lucko.luckperms.common.web.Pastebin;
import me.lucko.luckperms.lib.okhttp3.MediaType;
import me.lucko.luckperms.lib.okhttp3.RequestBody;

public enum StandardPastebin implements Pastebin
{
    BYTEBIN{
        public static final String URL = "https://bytebin.lucko.me/";
        private static final String POST_URL = "https://bytebin.lucko.me/post";

        @Override
        public String getPostUrl() {
            return POST_URL;
        }

        @Override
        protected String parseIdFromResult(BufferedReader reader) {
            JsonObject object = (JsonObject)GsonProvider.prettyPrinting().fromJson((Reader)reader, JsonObject.class);
            return object.get("key").getAsString();
        }

        @Override
        public String getRawUrl(String id) {
            return URL + id;
        }
    }
    ,
    HASTEBIN{
        private static final String URL = "https://hastebin.com/";
        private static final String RAW_URL = "https://hastebin.com/raw/";
        private static final String POST_URL = "https://hastebin.com/documents";

        @Override
        public String getPostUrl() {
            return POST_URL;
        }

        @Override
        protected String parseIdFromResult(BufferedReader reader) {
            JsonObject object = (JsonObject)GsonProvider.prettyPrinting().fromJson((Reader)reader, JsonObject.class);
            return object.get("key").getAsString();
        }

        @Override
        public String getRawUrl(String id) {
            return RAW_URL + id;
        }
    };

    private static final MediaType JSON_TYPE;
    private static final MediaType PLAIN_TYPE;

    protected abstract String getPostUrl();

    protected abstract String parseIdFromResult(BufferedReader var1);

    @Override
    public Pastebin.Paste postJson(JsonElement content, boolean compress) {
        OutputStream outputStream;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        if (compress) {
            try {
                outputStream = new GZIPOutputStream(byteOut);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            outputStream = byteOut;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            GsonProvider.prettyPrinting().toJson(content, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.post(RequestBody.create((MediaType)JSON_TYPE, (byte[])byteOut.toByteArray()), compress);
    }

    @Override
    public Pastebin.Paste postPlain(String content) {
        return this.post(RequestBody.create((MediaType)PLAIN_TYPE, (String)content), false);
    }

    /*
     * Exception decompiling
     */
    private Pastebin.Paste post(RequestBody body, boolean compressed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
        PLAIN_TYPE = MediaType.parse((String)"text/plain; charset=utf-8");
    }

    private static final class Paste
    implements Pastebin.Paste {
        private final String url;
        private final String id;

        private Paste(String url, String id) {
            this.url = url;
            this.id = id;
        }

        @Override
        public String url() {
            return this.url;
        }

        @Override
        public String id() {
            return this.id;
        }
    }
}

