/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.RankUpper;

import br.net.fabiozumbi12.RankUpper.RUUtil;
import br.net.fabiozumbi12.RankUpper.RankUpper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;

public class RULang {
    private static final HashMap<Player, String> DelayedMessage = new HashMap();
    static Properties BaseLang = new Properties();
    static Properties Lang = new Properties();
    static String pathLang;
    static String resLang;

    public SortedSet<String> helpStrings() {
        TreeSet<String> values = new TreeSet<String>();
        for (Object help : Lang.keySet()) {
            if (!help.toString().startsWith("commands.help.")) continue;
            values.add(help.toString().replace("commands.help.", ""));
        }
        return values;
    }

    public RULang() {
        resLang = "lang" + RankUpper.get().getConfig().root().language + ".properties";
        pathLang = RankUpper.get().getConfigDir() + File.separator + resLang;
        File lang = new File(pathLang);
        if (!lang.exists()) {
            if (!RankUpper.get().instance().getAsset(resLang).isPresent()) {
                resLang = "langEN-US.properties";
                pathLang = RankUpper.get().getConfigDir() + File.separator + resLang;
            }
            try {
                ((Asset)RankUpper.get().instance().getAsset(resLang).get()).copyToDirectory(RankUpper.get().getConfigDir().toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            RankUpper.get().getLogger().info("Created lang file: " + pathLang);
        }
        this.loadLang();
        this.loadBaseLang();
        RankUpper.get().getLogger().info("Language file loaded - Using: " + RankUpper.get().getConfig().root().language);
    }

    private void loadBaseLang() {
        BaseLang.clear();
        try {
            BaseLang.load(((Asset)RankUpper.get().instance().getAsset("langEN-US.properties").get()).getUrl().openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateLang();
    }

    private void loadLang() {
        int rpv;
        int langv;
        Lang.clear();
        try {
            FileInputStream fileInput = new FileInputStream(pathLang);
            InputStreamReader reader = new InputStreamReader((InputStream)fileInput, "UTF-8");
            Lang.load(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Lang.get("_lang.version") != null && ((langv = Integer.parseInt(Lang.get("_lang.version").toString().replace(".", ""))) < (rpv = Integer.parseInt(((String)RankUpper.get().instance().getVersion().get()).replace(".", ""))) || langv == 0)) {
            RankUpper.get().getLogger().warning("Your lang file is outdated. Probally need strings updates!");
            RankUpper.get().getLogger().warning("Lang file version: " + Lang.get("_lang.version"));
            Lang.put("_lang.version", RankUpper.get().instance().getVersion().get());
        }
    }

    private void updateLang() {
        for (Map.Entry<Object, Object> linha : BaseLang.entrySet()) {
            if (Lang.containsKey(linha.getKey())) continue;
            Lang.put(linha.getKey(), linha.getValue());
        }
        if (!Lang.containsKey("_lang.version")) {
            Lang.put("_lang.version", RankUpper.get().instance().getVersion().get());
        }
        try {
            Lang.store(new OutputStreamWriter((OutputStream)new FileOutputStream(pathLang), "UTF-8"), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String get(String key) {
        String FMsg = Lang.get(key) == null ? "&c&oMissing language string for &4" + key : Lang.get(key).toString();
        return FMsg;
    }

    public void sendMessage(CommandSource p, String key) {
        if (Lang.get(key) == null) {
            p.sendMessage(RUUtil.toText(this.get("_rankupper.prefix") + " " + key));
        } else if (!this.get(key).equalsIgnoreCase("")) {
            p.sendMessage(RUUtil.toText(this.get("_rankupper.prefix") + " " + this.get(key)));
        }
    }

    public void sendMessage(Player p, String key) {
        if (DelayedMessage.containsKey(p) && DelayedMessage.get(p).equals(key)) {
            return;
        }
        if (Lang.get(key) == null) {
            p.sendMessage(RUUtil.toText(this.get("_rankupper.prefix") + " " + key));
        } else {
            if (this.get(key).equalsIgnoreCase("")) {
                return;
            }
            p.sendMessage(RUUtil.toText(this.get("_rankupper.prefix") + " " + this.get(key)));
        }
        DelayedMessage.put(p, key);
        Sponge.getScheduler().createSyncExecutor((Object)RankUpper.get()).schedule(() -> {
            if (DelayedMessage.containsKey(p)) {
                DelayedMessage.remove(p);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    public String translBool(String bool) {
        return this.get("region." + bool);
    }

    public String translBool(Boolean bool) {
        return this.get("region." + bool.toString());
    }
}

