/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.RankUpper.config;

import br.net.fabiozumbi12.RankUpper.RUUtil;
import br.net.fabiozumbi12.RankUpper.RankUpper;
import br.net.fabiozumbi12.RankUpper.config.StatsCategory;
import br.net.fabiozumbi12.RankUpper.hooks.RUAFK;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;

public class PlayerStatsDB {
    private StatsCategory stats = new StatsCategory();

    public StatsCategory stats() {
        return this.stats;
    }

    public PlayerStatsDB() {
        try {
            File statConfig = new File(RankUpper.get().getConfigDir(), "playerstats.conf");
            if (statConfig.exists()) {
                HoconConfigurationLoader statsManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(statConfig)).build();
                CommentedConfigurationNode tempStats = (CommentedConfigurationNode)statsManager.load();
                RankUpper.get().getLogger().warning("Converting player stats to new format...");
                for (Map.Entry node : tempStats.getChildrenMap().entrySet()) {
                    this.stats.players.put(node.getKey().toString(), new StatsCategory.PlayerInfoCategory(((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"JoinDate"}).getString(), ((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"LastVisist"}).getString(), ((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"PlayerName"}).getString(), ((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"TimePlayed"}).getInt()));
                    RankUpper.get().getLogger().warning("Importing: " + node.getKey().toString() + " = " + ((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"JoinDate"}).getString() + ", " + ((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"LastVisist"}).getString() + ", " + ((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"PlayerName"}).getString() + ", " + ((CommentedConfigurationNode)node.getValue()).getNode(new Object[]{"TimePlayed"}).getString() + ", ");
                }
                RankUpper.get().getLogger().warning("Player stats imported to database!");
                File backup = new File(RankUpper.get().getConfigDir(), "playerstats-old.conf");
                if (backup.exists()) {
                    backup.delete();
                }
                statConfig.renameTo(new File(RankUpper.get().getConfigDir(), "playerstats-old.conf"));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.loadPlayerStats();
        this.savePlayersStats();
    }

    public void loadPlayerStats() {
        try (Connection conn = RankUpper.get().getConnection();){
            String table = "CREATE TABLE IF NOT EXISTS " + RankUpper.get().getConfig().root().database.prefix + "players (uuid varchar(64) primary key, joindate varchar(64), name varchar(64), lastvisit varchar(64), time bigint)";
            conn.prepareStatement(table).execute();
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM " + RankUpper.get().getConfig().root().database.prefix + "players");
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                StatsCategory.PlayerInfoCategory pinfo = new StatsCategory.PlayerInfoCategory(results.getString("joindate"), results.getString("lastvisit"), results.getString("name"), results.getInt("time"));
                this.stats.players.put(results.getString("uuid"), pinfo);
            }
        }
        catch (SQLException e) {
            RankUpper.get().getLogger().severe("Player stats could not be loaded or created!");
            e.printStackTrace();
        }
    }

    public void savePlayersStats() {
        try (Connection conn = RankUpper.get().getConnection();){
            for (Map.Entry<String, StatsCategory.PlayerInfoCategory> stat : this.stats.players.entrySet()) {
                if (stat.getValue().PlayerName == null) continue;
                RankUpper.get().getLogger().debug("\nStats: \nKey: " + stat.getKey() + "\nPlayerName: " + stat.getValue().PlayerName + "\nLastVisit: " + stat.getValue().LastVisit + "\nJoinDate: " + stat.getValue().JoinDate + "\nTimePlayed: " + stat.getValue().TimePlayed);
                String sql = "INSERT INTO " + RankUpper.get().getConfig().root().database.prefix + "players (uuid, joindate, lastvisit, name, time) VALUES(?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE joindate = ?, lastvisit = ?, name = ?, time = ?";
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.setString(1, stat.getKey());
                stmt.setString(2, stat.getValue().JoinDate);
                stmt.setString(3, stat.getValue().LastVisit);
                stmt.setString(4, stat.getValue().PlayerName);
                stmt.setInt(5, stat.getValue().TimePlayed);
                stmt.setString(6, stat.getValue().JoinDate);
                stmt.setString(7, stat.getValue().LastVisit);
                stmt.setString(8, stat.getValue().PlayerName);
                stmt.setInt(9, stat.getValue().TimePlayed);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void AddPlayer(User p) {
        String PlayerString = RankUpper.get().getConfig().root().use_uuids_instead_names ? p.getUniqueId().toString() : p.getName();
        StatsCategory.PlayerInfoCategory pStat = new StatsCategory.PlayerInfoCategory(RUUtil.DateNow(), RUUtil.DateNow(), p.getName(), 0);
        this.stats.players.put(PlayerString, pStat);
        this.savePlayersStats();
    }

    public void setPlayerTime(String pkey, int time) {
        if (this.stats.players.containsKey(pkey)) {
            this.stats.players.get((Object)pkey).TimePlayed = time;
        }
    }

    public int addPlayerTime(User p, int amount) {
        int time;
        String PlayerString = this.getPlayerKey(p);
        this.stats.players.get((Object)PlayerString).TimePlayed = time = this.stats.players.get((Object)PlayerString).TimePlayed + amount;
        return time;
    }

    public void setLastVisit(User p) {
        String PlayerString = this.getPlayerKey(p);
        this.stats.players.get((Object)PlayerString).LastVisit = RUUtil.DateNow();
    }

    public int getPlayerTime(String uuid) {
        return this.stats.players.containsKey(uuid) ? this.stats.players.get((Object)uuid).TimePlayed : 0;
    }

    public String getPlayerKey(User user) {
        if (RankUpper.get().getConfig().root().use_uuids_instead_names && this.stats.players.containsKey(user.getUniqueId().toString())) {
            return user.getUniqueId().toString();
        }
        if (!RankUpper.get().getConfig().root().use_uuids_instead_names && this.stats.players.containsKey(user.getName())) {
            return user.getName();
        }
        for (Map.Entry<String, StatsCategory.PlayerInfoCategory> values : this.stats.players.entrySet()) {
            if (values.getValue().PlayerName == null || !values.getValue().PlayerName.equals(user.getName())) continue;
            return values.getKey();
        }
        return null;
    }

    public HashMap<String, Object> getPlayerDB(User p) {
        HashMap<String, Object> pdb = new HashMap<String, Object>();
        String PlayerString = this.getPlayerKey(p);
        pdb.put("PlayerName", this.stats.players.get((Object)PlayerString).PlayerName);
        pdb.put("JoinDate", this.stats.players.get((Object)PlayerString).JoinDate);
        pdb.put("LastVisit", this.stats.players.get((Object)PlayerString).LastVisit);
        pdb.put("TimePlayed", this.stats.players.get((Object)PlayerString).TimePlayed);
        return pdb;
    }

    public void AddPlayerTimes() {
        for (Player p : Sponge.getServer().getOnlinePlayers()) {
            if (RankUpper.get().getConfig().root().afk_support) {
                RankUpper.get().getLogger().debug("Berore check AFK!");
                if (RUAFK.isAFK(p)) {
                    RankUpper.get().getLogger().debug("After check AFK!");
                    continue;
                }
            }
            this.addPlayerTime((User)p, RankUpper.get().getConfig().root().update_player_time_minutes);
            if (!RankUpper.get().getConfig().root().auto_rankup) continue;
            RankUpper.get().getConfig().checkRankup((User)p);
        }
    }
}

