/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuTarget;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuTargetTank
extends ComponentMenuTarget {
    private static final String NBT_FULL = "ONLY_FULL";
    private static final int RADIO_BUTTON_SPACING = 12;
    private static final int RADIO_BUTTON_X = 36;
    private static final int RADIO_BUTTON_Y = 45;
    private boolean[] onlyFull = new boolean[directions.length];
    private RadioButtonList radioButtons = new RadioButtonList(){

        @Override
        public void updateSelectedOption(int selectedOption) {
            DataWriter dw = ComponentMenuTargetTank.this.getWriterForServerComponentPacket();
            dw.writeData(ComponentMenuTargetTank.this.selectedDirectionId, DataBitHelper.MENU_TARGET_DIRECTION_ID);
            dw.writeData(ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA.getId(), DataBitHelper.MENU_TARGET_TYPE_HEADER);
            dw.writeBoolean(selectedOption == 1);
            PacketHandler.sendDataToServer(dw);
        }
    };

    public ComponentMenuTargetTank(FlowComponent parent) {
        super(parent);
        this.radioButtons.add(new RadioButton(36, 45, Localization.EMPTY_TANK));
        this.radioButtons.add(new RadioButton(36, 57, Localization.FILLED_TANK));
    }

    @Override
    protected ComponentMenuTarget.Button getSecondButton() {
        return new ComponentMenuTarget.Button(27){

            @Override
            protected String getLabel() {
                return ComponentMenuTargetTank.this.useAdvancedSetting(ComponentMenuTargetTank.this.selectedDirectionId) ? Localization.ADVANCED_MODE.toString() : Localization.SIMPLE_MODE.toString();
            }

            @Override
            protected String getMouseOverText() {
                return ComponentMenuTargetTank.this.useAdvancedSetting(ComponentMenuTargetTank.this.selectedDirectionId) ? Localization.SIMPLE_MODE_LONG.toString() : Localization.ADVANCED_MODE_LONG.toString();
            }

            @Override
            protected void onClicked() {
                ComponentMenuTargetTank.this.writeData(ComponentMenuTarget.DataTypeHeader.USE_ADVANCED_SETTING, ComponentMenuTargetTank.this.useAdvancedSetting(ComponentMenuTargetTank.this.selectedDirectionId) ? 0 : 1);
            }
        };
    }

    @Override
    protected void writeAdvancedSetting(DataWriter dw, int i) {
        dw.writeBoolean(this.onlyFull[i]);
    }

    @Override
    protected void readAdvancedSetting(DataReader dr, int i) {
        this.onlyFull[i] = dr.readBoolean();
    }

    @Override
    protected void resetAdvancedSetting(int i) {
        this.onlyFull[i] = false;
    }

    @Override
    protected void copyAdvancedSetting(ComponentMenu menu, int i) {
        ComponentMenuTargetTank menuTarget = (ComponentMenuTargetTank)menu;
        this.onlyFull[i] = menuTarget.onlyFull[i];
    }

    @Override
    protected void refreshAdvancedComponentData(ContainerManager container, ComponentMenu newData, int i) {
        ComponentMenuTargetTank newDataTarget = (ComponentMenuTargetTank)newData;
        if (this.onlyFull[i] != newDataTarget.onlyFull[i]) {
            this.onlyFull[i] = newDataTarget.onlyFull[i];
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(i, DataBitHelper.MENU_TARGET_DIRECTION_ID);
            dw.writeData(ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA.getId(), DataBitHelper.MENU_TARGET_TYPE_HEADER);
            dw.writeBoolean(this.onlyFull[i]);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    protected void loadAdvancedComponent(NBTTagCompound directionTag, int i) {
        this.onlyFull[i] = directionTag.func_74767_n(NBT_FULL);
    }

    @Override
    protected void saveAdvancedComponent(NBTTagCompound directionTag, int i) {
        directionTag.func_74757_a(NBT_FULL, this.onlyFull[i]);
    }

    @Override
    protected void refreshAdvancedComponent() {
        if (this.selectedDirectionId != -1) {
            this.radioButtons.setSelectedOption(this.onlyFull[this.selectedDirectionId] ? 1 : 0);
        }
    }

    @Override
    protected void onAdvancedClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawAdvancedComponent(GuiManager gui, int mX, int mY) {
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    protected void readAdvancedNetworkComponent(DataReader dr, ComponentMenuTarget.DataTypeHeader header, int i) {
        this.onlyFull[i] = dr.readBoolean();
        this.refreshAdvancedComponent();
    }

    public boolean requireEmpty(int side) {
        return !this.onlyFull[side];
    }
}

