/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components.internal;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vswe.superfactory.components.internal.IItemBufferSubElement;

public class SlotStackInventoryHolder
implements IItemBufferSubElement {
    private IItemHandler inventory;
    private ItemStack itemStack;
    private int sizeRemaining;
    private int slot;

    public SlotStackInventoryHolder(ItemStack itemStack, IItemHandler inventory, int slot) {
        this.itemStack = itemStack;
        this.inventory = inventory;
        this.slot = slot;
        this.sizeRemaining = itemStack.func_190916_E();
    }

    @Override
    public void remove() {
        if (this.itemStack.func_190916_E() == 0) {
            IItemHandler handler = this.getInventory();
            if (handler instanceof IItemHandlerModifiable) {
                ((IItemHandlerModifiable)handler).setStackInSlot(this.getSlot(), ItemStack.field_190927_a);
            } else {
                this.getInventory().extractItem(this.getSlot(), Integer.MAX_VALUE, false);
            }
        }
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public int getSizeRemaining() {
        return Math.min(this.itemStack.func_190916_E(), this.sizeRemaining);
    }

    @Override
    public void reduceAmount(int amount) {
        if (amount == 0 || this.getSizeRemaining() < amount) {
            return;
        }
        this.inventory.extractItem(this.getSlot(), amount, false);
        this.sizeRemaining -= amount;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public SlotStackInventoryHolder getSplitElement(int elementAmount, int id, boolean fair) {
        int amountLeft;
        SlotStackInventoryHolder element = new SlotStackInventoryHolder(this.itemStack, this.inventory, this.slot);
        int oldAmount = this.getSizeRemaining();
        int amount = oldAmount / elementAmount;
        if (!fair && id < (amountLeft = oldAmount % elementAmount)) {
            ++amount;
        }
        element.sizeRemaining = amount;
        return element;
    }

    public String toString() {
        return "itemStack=" + this.itemStack + ", sizeRemaining=" + this.getSizeRemaining() + ", slot=" + this.slot;
    }
}

