/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.network.packets;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import vswe.superfactory.SuperFactoryManager;
import vswe.superfactory.interfaces.ContainerBase;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.settings.Settings;
import vswe.superfactory.tiles.TileEntityManager;
import vswe.superfactory.util.Utils;

public class DataWriter {
    private int bitCountBuffer;
    private int byteBuffer;
    private int idBits;
    private boolean idWritten;
    private int invBits;
    private boolean invWritten;
    private OutputStream stream;

    DataWriter() {
        this.stream = new ByteArrayOutputStream();
    }

    DataWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void writeBoolean(boolean data) {
        this.writeData(data ? 1 : 0, DataBitHelper.BOOLEAN);
    }

    void sendPlayerPackets(double x, double y, double z, double r, int dimension) {
        SuperFactoryManager.packetHandler.sendToAllAround(this.createPacket(), new NetworkRegistry.TargetPoint(dimension, x, y, z, r));
    }

    private FMLProxyPacket createPacket() {
        this.writeFinalBits();
        PacketBuffer buf = new PacketBuffer(Unpooled.copiedBuffer((byte[])((ByteArrayOutputStream)this.stream).toByteArray()));
        return new FMLProxyPacket(buf, "factorymanager");
    }

    void writeFinalBits() {
        if (this.bitCountBuffer > 0) {
            try {
                this.stream.write(this.byteBuffer);
                this.bitCountBuffer = 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void sendPlayerPacket(EntityPlayerMP player) {
        SuperFactoryManager.packetHandler.sendTo(this.createPacket(), player);
    }

    void sendServerPacket() {
        SuperFactoryManager.packetHandler.sendToServer(this.createPacket());
    }

    void sendPlayerPackets(ContainerBase container) {
        for (IContainerListener crafting : container.getCrafters()) {
            if (!(crafting instanceof EntityPlayer)) continue;
            EntityPlayerMP player = (EntityPlayerMP)crafting;
            SuperFactoryManager.packetHandler.sendTo(this.createPacket(), player);
        }
    }

    public void writeString(String str, DataBitHelper bits) {
        if (str != null) {
            byte[] bytes = str.getBytes();
            this.writeData(bytes.length, bits);
            int l = str.length() & (int)Math.pow(2.0, bits.getBitCount()) - 1;
            for (int i = 0; i < l; ++i) {
                this.writeByte(bytes[i]);
            }
        } else {
            this.writeData(0, bits);
        }
    }

    public void writeByte(int data) {
        this.writeData(data, 8);
    }

    public void writeData(int data, DataBitHelper bitCount) {
        this.writeData(data, bitCount.getBitCount());
    }

    public void writeData(int data, int bitCount) {
        long mask = (long)Math.pow(2.0, bitCount) - 1L;
        data = (int)((long)data & mask);
        while (this.bitCountBuffer + bitCount >= 8) {
            int bitsToAdd = 8 - this.bitCountBuffer;
            int addMask = (int)Math.pow(2.0, bitsToAdd) - 1;
            int addData = data & addMask;
            data >>>= bitsToAdd;
            this.byteBuffer |= (addData <<= this.bitCountBuffer);
            try {
                this.stream.write(this.byteBuffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.byteBuffer = 0;
            bitCount -= bitsToAdd;
            this.bitCountBuffer = 0;
        }
        this.byteBuffer |= data << this.bitCountBuffer;
        this.bitCountBuffer += bitCount;
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        byte[] bytes = null;
        if (nbtTagCompound != null) {
            try {
                bytes = Utils.compress(nbtTagCompound);
            }
            catch (IOException ex) {
                bytes = null;
            }
        }
        this.writeBoolean(bytes != null);
        if (bytes != null) {
            this.writeData(bytes.length, DataBitHelper.NBT_LENGTH);
            for (byte b : bytes) {
                this.writeByte(b);
            }
        }
    }

    public void writeComponentId(TileEntityManager manager, int id) {
        if (!this.idWritten) {
            if (Settings.isLimitless(manager) && manager.getFlowItems().size() > 511) {
                this.writeBoolean(true);
                int count = manager.getFlowItems().size();
                this.idBits = (int)(Math.log10(count + 1) / Math.log10(2.0)) + 1;
                this.writeData(this.idBits, DataBitHelper.BIT_COUNT);
            } else {
                this.writeBoolean(false);
                this.idBits = DataBitHelper.FLOW_CONTROL_COUNT.getBitCount();
            }
            this.idWritten = true;
        }
        this.writeData(id, this.idBits);
    }

    public void writeInventoryId(TileEntityManager manager, int id) {
        if (!this.invWritten) {
            manager.updateFirst();
            if (Settings.isLimitless(manager) && manager.getConnectedInventories().size() > 1023) {
                this.writeBoolean(true);
                int count = manager.getConnectedInventories().size();
                this.invBits = (int)(Math.log10(count + 1) / Math.log10(2.0)) + 1;
                this.writeData(this.invBits, DataBitHelper.BIT_COUNT);
            } else {
                this.writeBoolean(false);
                this.invBits = DataBitHelper.MENU_INVENTORY_SELECTION.getBitCount();
            }
            this.invWritten = true;
        }
        this.writeData(id, this.invBits);
    }

    void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

