/*
 * Decompiled with CFR 0.152.
 */
package forestry.book;

import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntry;
import forestry.api.book.IForesterBook;
import forestry.book.BookCategory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ForesterBook
implements IForesterBook {
    private final Map<String, IBookCategory> categoriesByName = new HashMap<String, IBookCategory>();

    @Override
    public Collection<String> getCategoryNames() {
        return this.categoriesByName.keySet();
    }

    @Override
    public IBookCategory addCategory(String name) {
        IBookCategory category = this.getCategory(name);
        if (category == null) {
            category = new BookCategory(name);
            this.categoriesByName.put(name, category);
        }
        return category;
    }

    void addCategories(IBookCategory[] categories) {
        for (IBookCategory category : categories) {
            this.categoriesByName.put(category.getName(), category);
        }
    }

    @Override
    @Nullable
    public IBookCategory getCategory(String name) {
        return this.categoriesByName.get(name);
    }

    @Override
    public Collection<IBookCategory> getCategories() {
        return this.categoriesByName.values();
    }

    @Override
    public Collection<IBookEntry> getEntries(String category) {
        IBookCategory c = this.getCategory(category);
        return c == null ? Collections.emptySet() : c.getEntries();
    }

    @Override
    @Nullable
    public IBookEntry getEntry(String name) {
        for (IBookCategory category : this.categoriesByName.values()) {
            for (IBookEntry entry : category.getEntries()) {
                if (!entry.getName().equalsIgnoreCase(name)) continue;
                return entry;
            }
        }
        return null;
    }
}

