/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.IFaucetDepth;
import slimeknights.tconstruct.smeltery.block.BlockChannel;
import slimeknights.tconstruct.smeltery.tileentity.TileChannel;

public class ChannelRenderer
extends FastTESR<TileChannel> {
    private static Minecraft mc = Minecraft.func_71410_x();

    public void renderTileEntityFast(@Nonnull TileChannel te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder renderer) {
        FluidStack fluidStack = te.getTank().getFluid();
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        renderer.func_178969_c(x, y, z);
        int color = fluid.getColor(fluidStack);
        int brightness = te.func_145831_w().func_175626_b(te.func_174877_v(), fluid.getLuminosity());
        TextureMap map = mc.func_147117_R();
        TextureAtlasSprite still = map.getTextureExtry(fluid.getStill(fluidStack).toString());
        TextureAtlasSprite flowing = map.getTextureExtry(fluid.getFlowing(fluidStack).toString());
        double x1 = 0.0;
        double z1 = 0.0;
        double x2 = 0.0;
        double z2 = 0.0;
        EnumFacing rotation = null;
        EnumFacing oneOutput = null;
        int outputs = 0;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            TileChannel.ChannelConnection connection = te.getConnection(side);
            if (!TileChannel.ChannelConnection.canFlow(connection)) continue;
            if (te.isFlowing(side)) {
                BlockPos offsetPos = pos.func_177972_a(side);
                switch (side) {
                    case NORTH: {
                        x1 = 0.375;
                        z1 = 0.0;
                        x2 = 0.625;
                        z2 = 0.375;
                        break;
                    }
                    case SOUTH: {
                        x1 = 0.375;
                        z1 = 0.625;
                        x2 = 0.625;
                        z2 = 1.0;
                        break;
                    }
                    case WEST: {
                        x1 = 0.0;
                        z1 = 0.375;
                        x2 = 0.375;
                        z2 = 0.625;
                        break;
                    }
                    case EAST: {
                        x1 = 0.625;
                        z1 = 0.375;
                        x2 = 1.0;
                        z2 = 0.625;
                    }
                }
                if (!(world.func_180495_p(offsetPos).func_177230_c() instanceof BlockChannel)) {
                    RenderUtil.putTexturedQuad(renderer, flowing, x1, 0.375, z1, x2 - x1, 0.09375, z2 - z1, side, color, brightness, true);
                }
                if (connection == TileChannel.ChannelConnection.IN) {
                    rotation = side;
                } else {
                    rotation = side.func_176734_d();
                    ++outputs;
                    oneOutput = rotation;
                }
                RenderUtil.putRotatedQuad(renderer, flowing, x1, 0.46875, z1, x2 - x1, z2 - z1, rotation, color, brightness, true);
                continue;
            }
            RenderUtil.putTexturedQuad(renderer, flowing, 0.375, 0.375, 0.375, 0.25, 0.09375, 0.25, side, color, brightness, true);
        }
        if (outputs == 1) {
            RenderUtil.putRotatedQuad(renderer, flowing, 0.375, 0.46875, 0.375, 0.25, 0.25, oneOutput, color, brightness, true);
        } else {
            RenderUtil.putTexturedQuad(renderer, still, 0.375, 0.46875, 0.375, 0.25, 0.0, 0.25, EnumFacing.UP, color, brightness, false);
        }
        if (te.isConnectedDown()) {
            double h;
            double y1;
            double xz1 = 0.375;
            double wd = 0.25;
            if (te.isFlowingDown()) {
                BlockPos below = pos.func_177977_b();
                IBlockState state = world.func_180495_p(below);
                Block block = state.func_177230_c();
                float yMin = -0.9375f;
                if (block instanceof IFaucetDepth) {
                    yMin = -((IFaucetDepth)block).getFlowDepth(world, below, state);
                }
                y1 = 0.0;
                h = 0.125;
                RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.NORTH, color, brightness, true);
                RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.EAST, color, brightness, true);
                RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.SOUTH, color, brightness, true);
                RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.WEST, color, brightness, true);
                if (yMin < 0.0f) {
                    y1 = yMin;
                    h = -yMin;
                    RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.NORTH, color, brightness, true);
                    RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.EAST, color, brightness, true);
                    RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.SOUTH, color, brightness, true);
                    RenderUtil.putTexturedQuad(renderer, flowing, xz1, y1, xz1, wd, h, wd, EnumFacing.WEST, color, brightness, true);
                }
            } else {
                y1 = 0.375;
                h = 0.0;
            }
            RenderUtil.putTexturedQuad(renderer, still, xz1, y1, xz1, wd, h, wd, EnumFacing.DOWN, color, brightness, false);
        }
    }
}

