/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices.modular;

import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import io.github.nucleuspowered.nucleus.dataservices.modular.DataModule;
import io.github.nucleuspowered.nucleus.dataservices.modular.DataModuleFactory;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularDataService;
import io.github.nucleuspowered.nucleus.dataservices.modular.TransientModule;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.storage.WorldProperties;

public class ModularWorldService
extends ModularDataService<ModularWorldService> {
    private static final int CURRENT_VERSION = 1;
    private final UUID worldUUID;

    public ModularWorldService(DataProvider<ConfigurationNode> dataProvider, UUID worldUUID) throws Exception {
        super(dataProvider);
        this.worldUUID = worldUUID;
    }

    public UUID getWorldUUID() {
        return this.worldUUID;
    }

    @Override
    protected String serviceName() {
        return "Nucleus Data for world " + this.worldUUID.toString() + " (" + Sponge.getServer().getWorldProperties(this.worldUUID).map(WorldProperties::getWorldName).orElse("unknown") + ")";
    }

    @Override
    <T extends TransientModule<ModularWorldService>> Optional<T> tryGetTransient(Class<T> module) {
        return DataModuleFactory.getTransient(module, this);
    }

    @Override
    <T extends DataModule<ModularWorldService>> Optional<T> tryGet(Class<T> module) {
        return DataModuleFactory.get(module, this);
    }
}

