/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fly.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.fly.commands.FlyCommand;
import io.github.nucleuspowered.nucleus.modules.fly.config.FlyConfig;
import io.github.nucleuspowered.nucleus.modules.fly.config.FlyConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.fly.datamodules.FlyUserDataModule;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.World;

public class FlyListener
implements Reloadable,
ListenerBase {
    private FlyConfig flyConfig = new FlyConfig();
    private CommandPermissionHandler flyCommandHandler = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(FlyCommand.class);

    @Listener(order=Order.FIRST)
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player pl) {
        if (FlyListener.shouldIgnoreFromGameMode(pl)) {
            return;
        }
        if (this.flyConfig.isPermissionOnLogin() && !this.flyCommandHandler.testBase((Subject)pl)) {
            this.safeTeleport(pl);
            return;
        }
        Optional<ModularUserService> serviceOptional = Nucleus.getNucleus().getUserDataManager().get((User)pl);
        if (serviceOptional.isPresent() && serviceOptional.get().get(FlyUserDataModule.class).isFlyingSafe()) {
            pl.offer(Keys.CAN_FLY, (Object)true);
            if (pl.getLocation().add(0.0, -1.0, 0.0).getBlockType().getId().equals(BlockTypes.AIR.getId())) {
                pl.offer(Keys.IS_FLYING, (Object)true);
            }
            return;
        }
        this.safeTeleport(pl);
    }

    @Listener
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event, @Getter(value="getTargetEntity") Player pl) {
        if (!this.flyConfig.isSaveOnQuit()) {
            return;
        }
        if (FlyListener.shouldIgnoreFromGameMode(pl)) {
            return;
        }
        try {
            Nucleus.getNucleus().getUserDataManager().getUnchecked((User)pl).get(FlyUserDataModule.class).setFlying(pl.get(Keys.CAN_FLY).orElse(false));
        }
        catch (Exception e) {
            Nucleus.getNucleus().printStackTraceIfDebugMode(e);
        }
    }

    @Listener(order=Order.LAST)
    public void onPlayerTransferWorld(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Entity target, @Getter(value="getFromTransform") Transform<World> twfrom, @Getter(value="getToTransform") Transform<World> twto) {
        ModularUserService uc;
        if (!(target instanceof Player)) {
            return;
        }
        Player pl = (Player)target;
        if (FlyListener.shouldIgnoreFromGameMode(pl)) {
            return;
        }
        try {
            uc = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)pl);
            if (!uc.get(FlyUserDataModule.class).isFlying()) {
                return;
            }
        }
        catch (Exception e) {
            Nucleus.getNucleus().printStackTraceIfDebugMode(e);
            return;
        }
        boolean isFlying = target.get(Keys.IS_FLYING).orElse(false);
        if (!((World)twfrom.getExtent()).getUniqueId().equals(((World)twto.getExtent()).getUniqueId())) {
            Sponge.getScheduler().createTaskBuilder().execute(() -> {
                if (this.getFlyCommandHandler().testBase((Subject)pl)) {
                    target.offer(Keys.CAN_FLY, (Object)true);
                    if (isFlying) {
                        target.offer(Keys.IS_FLYING, (Object)true);
                    }
                } else {
                    uc.get(FlyUserDataModule.class).setFlying(false);
                    target.offer(Keys.CAN_FLY, (Object)false);
                    target.offer(Keys.IS_FLYING, (Object)false);
                }
            }).submit((Object)Nucleus.getNucleus());
        }
    }

    static boolean shouldIgnoreFromGameMode(Player player) {
        GameMode gm = player.get(Keys.GAME_MODE).orElse(GameModes.NOT_SET);
        return gm.equals(GameModes.CREATIVE) || gm.equals(GameModes.SPECTATOR);
    }

    private CommandPermissionHandler getFlyCommandHandler() {
        if (this.flyCommandHandler == null) {
            this.flyCommandHandler = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(FlyCommand.class);
        }
        return this.flyCommandHandler;
    }

    @Override
    public void onReload() throws Exception {
        this.flyConfig = (FlyConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(FlyConfigAdapter.class).getNode();
    }

    private void safeTeleport(Player pl) {
        if (!pl.isOnGround() && this.flyConfig.isFindSafeOnLogin()) {
            Nucleus.getNucleus().getTeleportHandler().teleportPlayer(pl, (Transform<World>)pl.getTransform(), NucleusTeleportHandler.StandardTeleportMode.SAFE_TELEPORT_DESCEND);
        }
    }
}

