/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.InfoArgument;
import io.github.nucleuspowered.nucleus.internal.TextFileController;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfig;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.info.services.InfoHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.USER)
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"info", "einfo"})
@EssentialsEquivalent(value={"info", "ifo", "news", "about", "inform"})
public class InfoCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final InfoHandler infoHandler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(InfoHandler.class);
    private InfoConfig infoConfig = new InfoConfig();
    private final String key = "section";

    @Override
    public void onReload() {
        this.infoConfig = (InfoConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(InfoConfigAdapter.class).getNodeOrDefault();
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> map = new HashMap<String, PermissionInformation>();
        map.put("list", PermissionInformation.getWithTranslation("permission.info.list", SuggestedLevel.ADMIN));
        return map;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("list"), new String[]{"l", "-list"}).buildWith(GenericArguments.optional((CommandElement)new InfoArgument((Text)Text.of((String)this.key), this.infoHandler)))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String def;
        Optional<TextFileController> list;
        Optional<InfoArgument.Result> oir = args.getOne(this.key);
        if (this.infoConfig.isUseDefaultFile() && !oir.isPresent() && !args.hasAny("l") && (list = this.infoHandler.getSection(def = this.infoConfig.getDefaultInfoSection())).isPresent()) {
            oir = Optional.of(new InfoArgument.Result(this.infoHandler.getInfoSections().stream().filter(def::equalsIgnoreCase).findFirst().get(), list.get()));
        }
        if (oir.isPresent()) {
            TextFileController controller = ((InfoArgument.Result)oir.get()).text;
            Text def2 = TextSerializers.FORMATTING_CODE.deserialize(((InfoArgument.Result)oir.get()).name);
            Text title = Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.info.title.section", controller.getTitle(src).orElseGet(() -> Text.of((Object[])new Object[]{def2})));
            controller.sendToPlayer(src, title);
            return CommandResult.success();
        }
        Set<String> sections = this.infoHandler.getInfoSections();
        if (sections.isEmpty()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.info.none", new String[0]));
        }
        ArrayList s = Lists.newArrayList();
        sections.forEach(x -> {
            Text.Builder tb = Text.builder().append(new Text[]{Text.builder((String)x).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.info.hover", (String)x))).onClick((ClickAction)TextActions.runCommand((String)("/info " + x))).build()});
            this.infoHandler.getSection((String)x).get().getTitle(src).ifPresent(sub -> tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " - "})}).append(new Text[]{sub}));
            s.add(tb.build());
        });
        Util.getPaginationBuilder(src).contents(new Text[0]).header(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.info.header.default", new String[0])).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.info.title.default", new String[0])).contents((Iterable)s.stream().sorted(Comparator.comparing(Text::toPlain)).collect(Collectors.toList())).padding(Text.of((Object[])new Object[]{TextColors.GOLD, "-"})).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

