/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.modules.message.HelpOpMessageChannel;
import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfig;
import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.message.events.InternalNucleusHelpOpEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@Permissions(suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"helpop"})
@EssentialsEquivalent(value={"helpop", "amsg", "ac"})
@NonnullByDefault
public class HelpOpCommand
extends AbstractCommand<Player>
implements Reloadable {
    @Nullable
    private NucleusTextTemplateImpl prefix = null;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.MESSAGE};
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("receive", PermissionInformation.getWithTranslation("permission.helpop.receive", SuggestedLevel.MOD));
        return m;
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        String message = (String)args.getOne("message").get();
        if (Sponge.getEventManager().post((Event)new InternalNucleusHelpOpEvent((CommandSource)src, message))) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("message.cancel", new String[0]));
            return CommandResult.empty();
        }
        Text prefix = this.prefix == null ? Text.EMPTY : this.prefix.getForCommandSource((CommandSource)src);
        HelpOpMessageChannel.INSTANCE.send(src, TextParsingUtils.joinTextsWithColoursFlowing(new Text[]{prefix, Text.of((String)message)}));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.helpop.success", new String[0]));
        return CommandResult.success();
    }

    @Override
    public void onReload() {
        this.prefix = ((MessageConfig)((MessageConfigAdapter)this.getServiceUnchecked(MessageConfigAdapter.class)).getNodeOrDefault()).getHelpOpPrefix();
    }
}

