/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.servershop.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.ItemAliasArgument;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import io.github.nucleuspowered.nucleus.internal.EconHelper;
import io.github.nucleuspowered.nucleus.internal.annotations.RequiresEconomy;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@NonnullByDefault
@RequiresEconomy
@Permissions(suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"itemsellall", "sellall"})
public class SellAllCommand
extends AbstractCommand<Player> {
    private final ItemDataService itemDataService = Nucleus.getNucleus().getItemDataService();
    private final EconHelper econHelper = Nucleus.getNucleus().getEconHelper();
    private final String itemKey = "item";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"a", "-accept"}).buildWith(GenericArguments.none()), GenericArguments.optional((CommandElement)new ItemAliasArgument((Text)Text.of((String)this.itemKey)))};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        boolean accepted = args.hasAny("a");
        CatalogType ct = this.getCatalogTypeFromHandOrArgs((CommandSource)src, this.itemKey, args);
        String name = Util.getTranslatableIfPresentOnCatalogType(ct);
        String id = ct.getId();
        QueryOperation query = ct instanceof BlockState ? QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of((Object)ItemStack.builder().fromBlockState((BlockState)ct).quantity(1).build()) : QueryOperationTypes.ITEM_TYPE.of((Object)((ItemType)ct));
        ItemDataNode node = this.itemDataService.getDataForItem(id);
        double sellPrice = node.getServerSellPrice();
        if (sellPrice < 0.0) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.itemsell.notforselling", new String[0]));
        }
        Iterable slots = Util.getStandardInventory((Carrier)src).query(new QueryOperation[]{query}).slots();
        List itemsToSell = StreamSupport.stream(Util.getStandardInventory((Carrier)src).query(new QueryOperation[]{query}).slots().spliterator(), false).map(Inventory::peek).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        int amt = itemsToSell.stream().mapToInt(ItemStack::getQuantity).sum();
        if (amt <= 0) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itemsellall.none", new Text[]{Text.of((String)ct.getName())}));
        }
        double overallCost = sellPrice * (double)amt;
        if (accepted) {
            if (this.econHelper.depositInPlayer((User)src, overallCost, false)) {
                slots.forEach(Inventory::clear);
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itemsell.summary", new Text[]{Text.of((Object[])new Object[]{amt}), Text.of((String)name), Text.of((String)this.econHelper.getCurrencySymbol(overallCost))}));
                return CommandResult.success();
            }
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itemsell.error", new Text[]{Text.of((String)ct.getName())}));
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itemsellall.summary", new Text[]{Text.of((Object[])new Object[]{amt}), Text.of((String)name), Text.of((String)this.econHelper.getCurrencySymbol(overallCost)), Text.of((String)id)}).toBuilder().onClick((ClickAction)TextActions.runCommand((String)("/nucleus:itemsellall -a " + id))).build());
        return CommandResult.success();
    }
}

