/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import io.github.nucleuspowered.nucleus.modules.spawn.commands.SpawnCommand;
import io.github.nucleuspowered.nucleus.modules.spawn.config.GlobalSpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.spawn.events.SendToSpawnEvent;
import io.github.nucleuspowered.nucleus.modules.spawn.helpers.SpawnHelper;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@NoModifiers
@NonnullByDefault
@Permissions(prefix="spawn", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"other"}, subcommandOf=SpawnCommand.class)
public class SpawnOtherCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final String otherKey = "subject";
    private final String worldKey = "world";
    private GlobalSpawnConfig gsc = new GlobalSpawnConfig();
    private boolean safeTeleport = true;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.user((Text)Text.of((String)"subject")), GenericArguments.optional((CommandElement)GenericArguments.world((Text)Text.of((String)"world")))};
    }

    @Override
    public void onReload() throws Exception {
        SpawnConfig sc = (SpawnConfig)((SpawnConfigAdapter)this.getServiceUnchecked(SpawnConfigAdapter.class)).getNodeOrDefault();
        this.gsc = sc.getGlobalSpawn();
        this.safeTeleport = sc.isSafeTeleport();
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return new HashMap<String, PermissionInformation>(){
            {
                this.put("offline", PermissionInformation.getWithTranslation("permission.spawnother.offline", SuggestedLevel.ADMIN));
            }
        };
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        User target = (User)args.getOne("subject").get();
        WorldProperties world = this.getWorldProperties(src, "world", args).orElseGet(() -> this.gsc.isOnSpawnCommand() ? this.gsc.getWorld().get() : (WorldProperties)Sponge.getServer().getDefaultWorld().get());
        Transform<World> worldTransform = SpawnHelper.getSpawn(world, target.getPlayer().orElse(null));
        SendToSpawnEvent event = new SendToSpawnEvent(worldTransform, target, CauseStackHelper.createCause(src));
        if (Sponge.getEventManager().post((Event)event)) {
            if (event.getCancelReason().isPresent()) {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.other.failed.reason", target.getName(), event.getCancelReason().get()));
            }
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.other.failed.noreason", target.getName()));
        }
        if (!target.isOnline()) {
            return this.isOffline(src, target, worldTransform);
        }
        Player player = (Player)target.getPlayer().get();
        NucleusTeleportHandler.TeleportResult result = Nucleus.getNucleus().getTeleportHandler().teleportPlayer(player, worldTransform, this.safeTeleport, true);
        if (result.isSuccess()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.success.source", target.getName(), world.getWorldName()));
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.success.target", world.getWorldName()));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.spawnother.fail", target.getName(), world.getWorldName());
    }

    private CommandResult isOffline(CommandSource source, User user, Transform<World> worldTransform) throws Exception {
        if (!this.permissions.testSuffix((Subject)source, "offline")) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.offline.permission", new String[0]));
        }
        Nucleus.getNucleus().getUserDataManager().get(user).get().get(CoreUserDataModule.class).sendToLocationOnLogin((Location<World>)worldTransform.getLocation());
        source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawnother.offline.sendonlogin", user.getName(), ((World)worldTransform.getExtent()).getName()));
        return CommandResult.success();
    }
}

