/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.services;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.interfaces.CancellableTask;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.jail.datamodules.JailUserDataModule;
import io.github.nucleuspowered.nucleus.modules.teleport.TeleportUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.teleport.commands.TeleportAcceptCommand;
import io.github.nucleuspowered.nucleus.modules.teleport.commands.TeleportDenyCommand;
import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfigAdapter;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.World;

public class TeleportHandler
implements MessageProviderTrait,
InternalServiceManagerTrait,
PermissionTrait,
ServiceBase,
Reloadable {
    private boolean refundOnDeny;
    private final Map<UUID, TeleportPrep> ask = new HashMap<UUID, TeleportPrep>();
    private final String acceptPerm = this.getPermissionHandlerFor(TeleportAcceptCommand.class).getBase();
    private final String denyPerm = this.getPermissionHandlerFor(TeleportDenyCommand.class).getBase();
    private static final String tptoggleBypassPermission = "nucleus.teleport.tptoggle.exempt";

    public TeleportBuilder getBuilder() {
        return new TeleportBuilder();
    }

    private static boolean canBypassTpToggle(Subject from) {
        return Nucleus.getNucleus().getPermissionResolver().hasPermission(from, tptoggleBypassPermission);
    }

    public static boolean canTeleportTo(CommandSource source, User to) {
        UserPreferenceService ups;
        if (source instanceof Player && !TeleportHandler.canBypassTpToggle((Subject)source) && !(ups = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(UserPreferenceService.class)).get(to.getUniqueId(), TeleportUserPrefKeys.TELEPORT_TARGETABLE).orElse(true).booleanValue()) {
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("teleport.fail.targettoggle", to.getName()));
            return false;
        }
        return true;
    }

    public void addAskQuestion(UUID target, TeleportPrep tp) {
        this.clearExpired();
        this.get(target).ifPresent(x -> this.cancel((TeleportPrep)x, this.refundOnDeny));
        this.ask.put(target, tp);
    }

    public void clearExpired() {
        Instant now = Instant.now();
        this.ask.entrySet().stream().filter(x -> now.isAfter(((TeleportPrep)x.getValue()).getExpire())).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(x -> this.cancel(this.ask.remove(x), this.refundOnDeny));
    }

    public Optional<TeleportPrep> get(UUID uuid) {
        this.clearExpired();
        return Optional.ofNullable(this.ask.remove(uuid));
    }

    public boolean remove(UUID uuid) {
        TeleportPrep tp = this.ask.remove(uuid);
        this.cancel(tp, this.refundOnDeny);
        return tp != null;
    }

    public CommandResult accept(Player player) {
        return this.accept(player, null) ? CommandResult.success() : CommandResult.empty();
    }

    private boolean accept(Player player, @Nullable TeleportPrep target) {
        if (target == null && (target = (TeleportPrep)this.get(player.getUniqueId()).orElse(null)) == null) {
            this.sendMessageTo((CommandSource)player, "command.tpaccept.nothing");
            return false;
        }
        if (this.ask.get(player.getUniqueId()) == target) {
            this.ask.remove(player.getUniqueId());
        }
        if (target.isExpired()) {
            this.sendMessageTo((CommandSource)player, "command.tpaccept.nothing");
            return false;
        }
        target.setForceExpire(true);
        target.tpbuilder.startTeleport();
        this.sendMessageTo((CommandSource)player, "command.tpaccept.success");
        return true;
    }

    public CommandResult deny(Player player) {
        return this.deny(player, null) ? CommandResult.success() : CommandResult.empty();
    }

    private boolean deny(Player player, @Nullable TeleportPrep target) {
        if (target == null && (target = (TeleportPrep)this.get(player.getUniqueId()).orElse(null)) == null) {
            this.sendMessageTo((CommandSource)player, "command.tpdeny.fail");
            return false;
        }
        if (this.ask.get(player.getUniqueId()) == target) {
            this.ask.remove(player.getUniqueId());
        }
        if (target.isExpired()) {
            this.sendMessageTo((CommandSource)player, "command.tpdeny.fail");
            return false;
        }
        this.cancel(target, this.refundOnDeny);
        Sponge.getServer().getPlayer(target.getTpbuilder().source).ifPresent(source -> this.sendMessageTo((CommandSource)source, "command.tpdeny.denyrequester", Nucleus.getNucleus().getNameUtil().getName((User)player)));
        this.sendMessageTo((CommandSource)player, "command.tpdeny.deny");
        return true;
    }

    public Text getAcceptDenyMessage(Player forPlayer, TeleportPrep target) {
        return Text.builder().append(new Text[]{Text.builder().append(new Text[]{this.getMessageFor(forPlayer.getLocale(), "standard.accept")}).style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(forPlayer.getLocale(), "teleport.accept.hover"))).onClick((ClickAction)TextActions.executeCallback(src -> {
            if (target.isExpired() || !this.hasPermission((Subject)src, this.acceptPerm) || !(src instanceof Player)) {
                this.sendMessageTo((CommandSource)src, "command.tpaccept.nothing");
                return;
            }
            this.accept((Player)src, target);
        })).build()}).append(new Text[]{Text.of((String)" - ")}).append(new Text[]{Text.builder().append(new Text[]{this.getMessageFor(forPlayer.getLocale(), "standard.deny")}).style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(forPlayer.getLocale(), "teleport.deny.hover"))).onClick((ClickAction)TextActions.executeCallback(src -> {
            if (target.isExpired() || !this.hasPermission((Subject)src, this.denyPerm) || !(src instanceof Player)) {
                this.sendMessageTo((CommandSource)src, "command.tpdeny.fail");
                return;
            }
            this.deny((Player)src, target);
        })).build()}).build();
    }

    private void cancel(@Nullable TeleportPrep prep, boolean refund) {
        if (prep == null || prep.hasCancelRun()) {
            return;
        }
        prep.setForceExpire(true);
        prep.setCancelRun();
        if (refund && prep.charged != null && prep.cost > 0.0) {
            if (prep.charged.isOnline()) {
                prep.charged.getPlayer().ifPresent(x -> this.sendMessageTo((CommandSource)x, "teleport.prep.cancel", Nucleus.getNucleus().getEconHelper().getCurrencySymbol(prep.cost)));
            }
            Nucleus.getNucleus().getEconHelper().depositInPlayer(prep.charged, prep.cost);
        }
    }

    @Override
    public void onReload() {
        this.refundOnDeny = ((TeleportConfig)this.getServiceUnchecked(TeleportConfigAdapter.class).getNodeOrDefault()).isRefundOnDeny();
    }

    public static class TeleportPrep {
        private boolean forceExpire = false;
        private boolean hasCancelRun = false;
        private final Instant expire;
        private final User charged;
        private final double cost;
        private final TeleportBuilder tpbuilder;

        public TeleportPrep(Instant expire, User charged, double cost, TeleportBuilder tpbuilder) {
            this.expire = expire;
            this.charged = charged;
            this.cost = cost;
            this.tpbuilder = tpbuilder;
        }

        public boolean isExpired() {
            return this.forceExpire || Instant.now().isAfter(this.expire);
        }

        public void setForceExpire(boolean forceExpire) {
            this.forceExpire = forceExpire;
        }

        public Instant getExpire() {
            return this.expire;
        }

        public User getCharged() {
            return this.charged;
        }

        public double getCost() {
            return this.cost;
        }

        public boolean hasCancelRun() {
            return this.hasCancelRun;
        }

        public void setCancelRun() {
            this.hasCancelRun = true;
        }

        public TeleportBuilder getTpbuilder() {
            return this.tpbuilder;
        }
    }

    public static class TeleportBuilder
    implements InternalServiceManagerTrait,
    MessageProviderTrait {
        private UUID source;
        private UUID from;
        private UUID to;
        private UUID charge;
        private double cost;
        private int warmupTime = 0;
        private boolean bypassToggle = false;
        private boolean safe = this.getService(TeleportConfigAdapter.class).map(x -> ((TeleportConfig)x.getNodeOrDefault()).isUseSafeTeleport()).orElse(true);
        private boolean silentSource = false;
        private boolean silentTarget = false;
        @Nullable
        private Consumer<Player> successCallback;

        private TeleportBuilder() {
        }

        public TeleportBuilder setSafe(boolean safe) {
            this.safe = safe;
            return this;
        }

        public TeleportBuilder setSource(CommandSource source) {
            this.source = source instanceof User ? ((User)source).getUniqueId() : Util.consoleFakeUUID;
            return this;
        }

        public TeleportBuilder setFrom(Player from) {
            this.from = from.getUniqueId();
            return this;
        }

        public TeleportBuilder setTo(Player to) {
            this.to = to.getUniqueId();
            return this;
        }

        public TeleportBuilder setCharge(Player charge) {
            this.charge = charge.getUniqueId();
            return this;
        }

        public TeleportBuilder setCost(double cost) {
            this.cost = cost;
            return this;
        }

        public TeleportBuilder setWarmupTime(int warmupTime) {
            this.warmupTime = warmupTime;
            return this;
        }

        public TeleportBuilder setBypassToggle(boolean bypassToggle) {
            this.bypassToggle = bypassToggle;
            return this;
        }

        public TeleportBuilder setSilentSource(boolean silent) {
            this.silentSource = silent;
            return this;
        }

        public TeleportBuilder setSilentTarget(boolean silentTarget) {
            this.silentTarget = silentTarget;
            return this;
        }

        public TeleportBuilder setSuccessCallback(@Nullable Consumer<Player> successCallback) {
            this.successCallback = successCallback;
            return this;
        }

        public boolean startTeleport() {
            Optional<User> ou;
            Preconditions.checkNotNull((Object)this.from);
            Preconditions.checkNotNull((Object)this.to);
            if (this.source == null) {
                this.source = this.from;
            }
            if (!(ou = Util.getUserFromUUID(this.source)).isPresent() || !ou.get().isOnline()) {
                return false;
            }
            CommandSource source = ou.map(x -> (Player)x.getPlayer().get()).orElseGet(() -> Sponge.getServer().getConsole());
            if (this.from.equals(this.to)) {
                this.sendMessageTo(source, "command.teleport.self");
                return false;
            }
            ModularUserService toPlayer = (ModularUserService)Nucleus.getNucleus().getUserDataManager().get(this.to).get();
            UserPreferenceService ups = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(UserPreferenceService.class);
            if (!(this.bypassToggle || ups.get(toPlayer.getUniqueId(), TeleportUserPrefKeys.TELEPORT_TARGETABLE).orElse(true).booleanValue() || TeleportHandler.canBypassTpToggle((Subject)source))) {
                this.sendMessageTo(source, "teleport.fail.targettoggle", toPlayer.getUser().getName());
                return false;
            }
            ModularUserService fromPlayer = (ModularUserService)Nucleus.getNucleus().getUserDataManager().get(this.from).get();
            if (Nucleus.getNucleus().isModuleLoaded("jail") && fromPlayer.get(JailUserDataModule.class).getJailData().isPresent()) {
                if (!this.silentSource) {
                    this.sendMessageTo(source, "teleport.fail.jailed", fromPlayer.getUser().getName());
                }
                return false;
            }
            if (!fromPlayer.getPlayer().isPresent()) {
                this.sendMessageTo(source, "teleport.fail.offlinenamed", fromPlayer.getUser().getName());
                return false;
            }
            if (!toPlayer.getPlayer().isPresent()) {
                this.sendMessageTo(source, "teleport.fail.offlinenamed", toPlayer.getUser().getName());
                return false;
            }
            TeleportTask tt = this.cost > 0.0 && this.charge != null ? new TeleportTask(source, fromPlayer.getPlayer().get(), toPlayer.getPlayer().get(), Util.getUserFromUUID(this.charge).get(), this.cost, this.safe, this.silentSource, this.silentTarget, this.successCallback) : new TeleportTask(source, fromPlayer.getPlayer().get(), toPlayer.getPlayer().get(), null, 0.0, this.safe, this.silentSource, this.silentTarget, this.successCallback);
            if (this.warmupTime > 0) {
                this.sendMessageTo((CommandSource)fromPlayer.getPlayer().get(), "teleport.warmup", this.warmupTime);
                Nucleus.getNucleus().getWarmupManager().addWarmup(this.from, Sponge.getScheduler().createTaskBuilder().delay((long)this.warmupTime, TimeUnit.SECONDS).execute((Consumer)tt).name("NucleusPlugin - Teleport Waiter").submit((Object)Nucleus.getNucleus()));
            } else {
                tt.run();
            }
            return true;
        }
    }

    private static class TeleportTask
    implements CancellableTask {
        private final Player playerToTeleport;
        private final Player playerToTeleportTo;
        private final User charged;
        private final double cost;
        private final boolean safe;
        private final CommandSource source;
        private final boolean silentSource;
        private final boolean silentTarget;
        @Nullable
        private final Consumer<Player> successCallback;

        private TeleportTask(CommandSource source, Player playerToTeleport, Player playerToTeleportTo, User charged, double cost, boolean safe, boolean silentSource, boolean silentTarget, @Nullable Consumer<Player> successCallback) {
            this.source = source;
            this.playerToTeleport = playerToTeleport;
            this.playerToTeleportTo = playerToTeleportTo;
            this.cost = cost;
            this.charged = charged;
            this.safe = safe;
            this.silentSource = silentSource;
            this.silentTarget = silentTarget;
            this.successCallback = successCallback;
        }

        private void run() {
            if (this.playerToTeleportTo.isOnline()) {
                NucleusTeleportHandler tpHandler = Nucleus.getNucleus().getTeleportHandler();
                NucleusTeleportHandler.StandardTeleportMode mode = this.safe ? tpHandler.getTeleportModeForPlayer(this.playerToTeleport) : NucleusTeleportHandler.StandardTeleportMode.NO_CHECK;
                NucleusTeleportHandler.TeleportResult result = tpHandler.teleportPlayer(this.playerToTeleport, (Transform<World>)this.playerToTeleportTo.getTransform(), (NucleusTeleportHandler.TeleportMode)mode, CauseStackHelper.createCause(this.source));
                if (!result.isSuccess()) {
                    if (!this.silentSource) {
                        this.source.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat(result == NucleusTeleportHandler.TeleportResult.FAILED_NO_LOCATION ? "teleport.nosafe" : "teleport.cancelled", new String[0]));
                    }
                    this.onCancel();
                    return;
                }
                if (!this.source.equals(this.playerToTeleport) && !this.silentSource) {
                    this.source.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("teleport.success.source", this.playerToTeleport.getName(), this.playerToTeleportTo.getName()));
                }
                this.playerToTeleport.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("teleport.to.success", this.playerToTeleportTo.getName()));
                if (!this.silentTarget) {
                    this.playerToTeleportTo.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("teleport.from.success", this.playerToTeleport.getName()));
                }
                if (this.successCallback != null && this.source instanceof Player) {
                    this.successCallback.accept((Player)this.source);
                }
            } else {
                if (!this.silentSource) {
                    this.source.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("teleport.fail.offline", new String[0]));
                }
                this.onCancel();
            }
        }

        @Override
        public void accept(Task task) {
            this.run();
        }

        @Override
        public void onCancel() {
            if (this.charged != null && this.cost > 0.0) {
                Nucleus.getNucleus().getEconHelper().depositInPlayer(this.charged, this.cost);
            }
        }
    }
}

