/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands.lists;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public abstract class AvailableBaseCommand
extends AbstractCommand<CommandSource> {
    private final Class<? extends CatalogType> catalogType;
    private final String titleKey;

    AvailableBaseCommand(Class<? extends CatalogType> catalogType, String titleKey) {
        this.catalogType = catalogType;
        this.titleKey = titleKey;
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
        List types = Sponge.getRegistry().getAllOf(this.catalogType).stream().map(x -> mp.getTextMessageWithFormat("command.world.presets.item", x.getId(), x.getName())).collect(Collectors.toList());
        Util.getPaginationBuilder(src).title(mp.getTextMessageWithTextFormat(this.titleKey, new Text[0])).contents(types).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

