/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.gui.overlay;

import micdoodle8.mods.galacticraft.core.client.gui.overlay.Overlay;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class OverlayDetectors
extends Overlay {
    private static Minecraft minecraft = FMLClientHandler.instance().getClient();

    public static void renderPressureIndicator(int pressureLevel, boolean invalid, boolean right, boolean top) {
        EntityPlayerSP player = OverlayDetectors.minecraft.field_71439_g;
        ResourceLocation guiTexture = new ResourceLocation("asmodeuscore", "textures/gui/gui.png");
        ScaledResolution scaledresolution = ClientUtil.getScaledRes((Minecraft)minecraft, (int)OverlayDetectors.minecraft.field_71443_c, (int)OverlayDetectors.minecraft.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        OverlayDetectors.minecraft.field_71460_t.func_78478_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(guiTexture);
        int minLeftX = 0;
        int maxLeftX = 0;
        int minRightX = 0;
        int maxRightX = 0;
        double bottomY = 0.0;
        double topY = 0.0;
        double zLevel = -190.0;
        float texMod = 0.00390625f;
        topY = top ? 0.0 : (double)(height - 68);
        bottomY = OxygenUtil.noAtmosphericCombustion((WorldProvider)player.field_70170_p.field_73011_w) ? topY + 57.5 : topY + 5.5;
        if (right) {
            minLeftX = width - 49;
            maxLeftX = width - 40;
            minRightX = width - 59;
            maxRightX = width - 74;
        } else {
            minLeftX = 10;
            maxLeftX = 29;
            minRightX = 10;
            maxRightX = 49;
        }
        if (pressureLevel > 48) {
            pressureLevel = 48;
        }
        pressureLevel = (int)((float)pressureLevel * 0.5f);
        OverlayDetectors.drawTexturedModalRect(minRightX, (float)bottomY + 1.0f, 49.0f, 9.0f, 0.0f, 0.0f, 64.0f, 9.0f, false, false, 256.0f, 256.0f);
        OverlayDetectors.drawTexturedModalRect(minRightX, (float)bottomY + 2.0f, pressureLevel, 6.0f, 0.0f, 9.0f, pressureLevel + 14, 6.0f, false, false, 256.0f, 256.0f);
        OverlayDetectors.drawTexturedModalRect(minRightX, (float)bottomY + 4.0f, 50.0f, 5.0f, 0.0f, 15.0f, 64.0f, 5.0f, false, false, 256.0f, 256.0f);
        if (invalid) {
            String value = GCCoreUtil.translate((String)"gui.warning.atmosphericpressure");
            if (right) {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX + 40 - OverlayDetectors.minecraft.field_71466_p.func_78256_a(value), (int)bottomY + 14 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)10, (int)10));
            } else {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX + 60, (int)bottomY + 14 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)10, (int)10));
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    public static void renderRadiationIndicator(int radLevel, boolean invalid, boolean right, boolean top) {
        EntityPlayerSP player = OverlayDetectors.minecraft.field_71439_g;
        ResourceLocation guiTexture = new ResourceLocation("asmodeuscore", "textures/gui/gui.png");
        ScaledResolution scaledresolution = ClientUtil.getScaledRes((Minecraft)minecraft, (int)OverlayDetectors.minecraft.field_71443_c, (int)OverlayDetectors.minecraft.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        OverlayDetectors.minecraft.field_71460_t.func_78478_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(guiTexture);
        int minLeftX = 0;
        int maxLeftX = 0;
        int minRightX = 0;
        int maxRightX = 0;
        double bottomY = 0.0;
        double topY = 0.0;
        double zLevel = -190.0;
        float texMod = 0.00390625f;
        topY = top ? 0.0 : (double)(height - 68);
        bottomY = OxygenUtil.noAtmosphericCombustion((WorldProvider)player.field_70170_p.field_73011_w) ? topY + 10.5 : topY + 5.5;
        if (right) {
            minLeftX = width - 49;
            maxLeftX = width - 40;
            minRightX = width - 69;
            maxRightX = width - 69;
        } else {
            minLeftX = 10;
            maxLeftX = 29;
            minRightX = 69;
            maxRightX = 69;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)maxRightX, bottomY + 56.0, zLevel).func_187315_a((double)(65.0f * texMod), (double)(56.0f * texMod)).func_181675_d();
        worldRenderer.func_181662_b((double)(maxRightX + 8), bottomY + 56.0, zLevel).func_187315_a((double)(73.0f * texMod), (double)(56.0f * texMod)).func_181675_d();
        worldRenderer.func_181662_b((double)(maxRightX + 8), bottomY, zLevel).func_187315_a((double)(73.0f * texMod), (double)(0.0f * texMod)).func_181675_d();
        worldRenderer.func_181662_b((double)maxRightX, bottomY, zLevel).func_187315_a((double)(65.0f * texMod), (double)(0.0f * texMod)).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)minRightX, bottomY + 56.0, zLevel).func_187315_a((double)(73.0f * texMod), (double)(56.0f * texMod)).func_181675_d();
        worldRenderer.func_181662_b((double)(maxRightX + 8), bottomY + 56.0, zLevel).func_187315_a((double)(81.0f * texMod), (double)(56.0f * texMod)).func_181675_d();
        worldRenderer.func_181662_b((double)(maxRightX + 8), bottomY + 56.0 - (double)radLevel, zLevel).func_187315_a((double)(81.0f * texMod), (double)((float)(56 - radLevel) * texMod)).func_181675_d();
        worldRenderer.func_181662_b((double)minRightX, bottomY + 56.0 - (double)radLevel, zLevel).func_187315_a((double)(73.0f * texMod), (double)((float)(56 - radLevel) * texMod)).func_181675_d();
        tessellator.func_78381_a();
        if (invalid) {
            String value = GCCoreUtil.translate((String)"gui.warning.solarradiation");
            if (right) {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX - 22 - OverlayDetectors.minecraft.field_71466_p.func_78256_a(value), (int)bottomY + 14 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)10));
            } else {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX + 75, (int)bottomY + 7 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)10));
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    public static void renderInfoPanel(float tempLevel, boolean invalid, boolean right, boolean top) {
        EntityPlayerSP player = OverlayDetectors.minecraft.field_71439_g;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        ResourceLocation guiTexture = new ResourceLocation("asmodeuscore", "textures/gui/gui.png");
        ScaledResolution scaledresolution = ClientUtil.getScaledRes((Minecraft)minecraft, (int)OverlayDetectors.minecraft.field_71443_c, (int)OverlayDetectors.minecraft.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        OverlayDetectors.minecraft.field_71460_t.func_78478_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(guiTexture);
        int minLeftX = 0;
        int maxLeftX = 0;
        int minRightX = 0;
        int maxRightX = 0;
        double bottomY = 0.0;
        double topY = 0.0;
        double zLevel = -190.0;
        float texMod = 0.00390625f;
        topY = top ? 0.0 : (double)height;
        bottomY = !OxygenUtil.noAtmosphericCombustion((WorldProvider)player.field_70170_p.field_73011_w) ? topY + 15.5 : topY + 67.0;
        if (right) {
            minLeftX = width - 49;
            maxLeftX = width - 40;
            minRightX = width - 72;
            maxRightX = width - 69;
        } else {
            minLeftX = 10;
            maxLeftX = 29;
            minRightX = 3;
            maxRightX = 69;
        }
        OverlayDetectors.drawTexturedModalRect(minRightX, (float)bottomY + 1.0f, 65.0f, 26.0f, 0.0f, 21.0f, 65.0f, 22.0f, !right, false, 256.0f, 256.0f);
        OverlayDetectors.drawTexturedModalRect((float)minRightX + 54.0f, (float)bottomY + 6.0f, 12.0f, 15.0f, 81.0f, 0.0f, 12.0f, 14.0f, !right, false, 256.0f, 256.0f);
        OverlayDetectors.minecraft.field_71466_p.func_78276_b(String.format("%.1f", Float.valueOf(tempLevel)) + " C", minRightX + 10 + (!right ? 12 : 0), (int)bottomY + 10, 0xFFFFFF);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedModalRect(double xOffset, double yOffset, float width, float height, float u, float v, float uWidth, float vHeight, boolean invertX, boolean invertY, float texSizeX, float texSizeY) {
        double zLevel = -200.0;
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        float texModX = 1.0f / texSizeX;
        float texModY = 1.0f / texSizeY;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float height0 = invertY ? 0.0f : vHeight;
        float height1 = invertY ? vHeight : 0.0f;
        float width0 = invertX ? uWidth : 0.0f;
        float width1 = invertX ? 0.0f : uWidth;
        worldRenderer.func_181662_b(xOffset, yOffset + (double)height, zLevel).func_187315_a((double)((u + width0) * texModX), (double)((v + height0) * texModY)).func_181675_d();
        worldRenderer.func_181662_b(xOffset + (double)width, yOffset + (double)height, zLevel).func_187315_a((double)((u + width1) * texModX), (double)((v + height0) * texModY)).func_181675_d();
        worldRenderer.func_181662_b(xOffset + (double)width, yOffset, zLevel).func_187315_a((double)((u + width1) * texModX), (double)((v + height1) * texModY)).func_181675_d();
        worldRenderer.func_181662_b(xOffset, yOffset, zLevel).func_187315_a((double)((u + width0) * texModX), (double)((v + height1) * texModY)).func_181675_d();
        tessellator.func_78381_a();
    }
}

