/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.event;

import asmodeuscore.AsmodeusCore;
import asmodeuscore.api.item.IItemPressurized;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesHelper;
import asmodeuscore.core.astronomy.gui.overlay.OverlayDetectors;
import asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.utils.ACAttributePlayer;
import asmodeuscore.core.utils.ACCompatibilityManager;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AsmodeusClientEvent {
    public Minecraft mc = FMLClientHandler.instance().getClient();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiCelestialSelection && AsmodeusConfig.enableNewGalaxyMap && !ACCompatibilityManager.isPlanetProgressionLoaded()) {
            GameSettings cfr_ignored_0 = this.mc.field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                event.setGui((GuiScreen)new NewGuiCelestialSelection(true, null, false, null));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!AsmodeusCore.HAS_GALACTICRAFT) {
            return;
        }
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        int level = 0;
        if (event.phase == TickEvent.Phase.END && player != null && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && OxygenUtil.shouldDisplayTankGui((GuiScreen)minecraft.field_71462_r) && !playerBaseClient.func_175149_v() && !minecraft.field_71474_y.field_74330_P) {
            IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w;
            BodiesData data = BodiesHelper.getData().get(provider.getCelestialBody());
            if (data != null) {
                level = data.getPressurePlanet();
            }
            if (level != 0) {
                OverlayDetectors.renderPressureIndicator(level, this.getInvalidLevel(1, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
            }
            if (data != null && data.getSolarRadiationPlanet()) {
                OverlayDetectors.renderRadiationIndicator((int)player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e(), this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
            }
            float temp = provider.getCelestialBody().atmosphere.thermalLevel() == 0.0f ? provider.getThermalLevelModifier() * (float)BodiesHelper.getDefaultDergrees + (float)BodiesHelper.getDefaultDergrees : provider.getThermalLevelModifier() * (float)BodiesHelper.getDefaultDergrees;
            OverlayDetectors.renderInfoPanel(temp, this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
        }
    }

    private boolean getInvalidLevel(int mode, int level) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        return mode == 1 ? !player.field_71075_bZ.field_75098_d && level > 25 && !AsmodeusClientEvent.getAtmoArmor((EntityPlayer)player) : mode == 2 && player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e() > 45.0;
    }

    public static boolean getAtmoArmor(EntityPlayer player) {
        for (int i = 0; i < 3; ++i) {
            if (!player.field_71071_by.func_70440_f(i).func_190926_b() && player.field_71071_by.func_70440_f(i).func_77973_b() instanceof IItemPressurized) continue;
            return false;
        }
        return true;
    }
}

