/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.init;

import cofh.core.item.ItemArmorCore;
import cofh.core.item.tool.ItemAxeCore;
import cofh.core.item.tool.ItemBowCore;
import cofh.core.item.tool.ItemExcavatorCore;
import cofh.core.item.tool.ItemFishingRodCore;
import cofh.core.item.tool.ItemHammerCore;
import cofh.core.item.tool.ItemHoeCore;
import cofh.core.item.tool.ItemHorseArmorCore;
import cofh.core.item.tool.ItemPickaxeCore;
import cofh.core.item.tool.ItemShearsCore;
import cofh.core.item.tool.ItemShieldCore;
import cofh.core.item.tool.ItemShovelCore;
import cofh.core.item.tool.ItemSickleCore;
import cofh.core.item.tool.ItemSwordCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFProps;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TFEquipment {
    public static final TFEquipment INSTANCE = new TFEquipment();
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_COPPER = EnumHelper.addArmorMaterial((String)"TF:COPPER", (String)"copper_armor", (int)10, (int[])new int[]{1, 3, 3, 1}, (int)8, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_TIN = EnumHelper.addArmorMaterial((String)"TF:TIN", (String)"tin_armor", (int)8, (int[])new int[]{1, 3, 4, 1}, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_SILVER = EnumHelper.addArmorMaterial((String)"TF:SILVER", (String)"silver_armor", (int)8, (int[])new int[]{2, 4, 4, 1}, (int)25, (SoundEvent)SoundEvents.field_187722_q, (float)0.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_LEAD = EnumHelper.addArmorMaterial((String)"TF:LEAD", (String)"lead_armor", (int)12, (int[])new int[]{2, 4, 5, 3}, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_ALUMINUM = EnumHelper.addArmorMaterial((String)"TF:ALUMINUM", (String)"aluminum_armor", (int)12, (int[])new int[]{1, 3, 4, 2}, (int)14, (SoundEvent)SoundEvents.field_187722_q, (float)0.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_NICKEL = EnumHelper.addArmorMaterial((String)"TF:NICKEL", (String)"nickel_armor", (int)15, (int[])new int[]{2, 5, 5, 2}, (int)18, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_PLATINUM = EnumHelper.addArmorMaterial((String)"TF:PLATINUM", (String)"platinum_armor", (int)35, (int[])new int[]{3, 6, 8, 3}, (int)16, (SoundEvent)SoundEvents.field_187716_o, (float)2.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_STEEL = EnumHelper.addArmorMaterial((String)"TF:STEEL", (String)"steel_armor", (int)22, (int[])new int[]{2, 5, 7, 2}, (int)10, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_ELECTRUM = EnumHelper.addArmorMaterial((String)"TF:ELECTRUM", (String)"electrum_armor", (int)8, (int[])new int[]{2, 4, 4, 2}, (int)30, (SoundEvent)SoundEvents.field_187722_q, (float)0.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_INVAR = EnumHelper.addArmorMaterial((String)"TF:INVAR", (String)"invar_armor", (int)21, (int[])new int[]{2, 5, 7, 2}, (int)12, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_BRONZE = EnumHelper.addArmorMaterial((String)"TF:BRONZE", (String)"bronze_armor", (int)18, (int[])new int[]{2, 6, 6, 2}, (int)10, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_CONSTANTAN = EnumHelper.addArmorMaterial((String)"TF:CONSTANTAN", (String)"constantan_armor", (int)13, (int[])new int[]{2, 4, 4, 2}, (int)12, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
    public static final Item.ToolMaterial TOOL_MATERIAL_COPPER = EnumHelper.addToolMaterial((String)"TF:COPPER", (int)1, (int)175, (float)4.0f, (float)1.0f, (int)7);
    public static final Item.ToolMaterial TOOL_MATERIAL_TIN = EnumHelper.addToolMaterial((String)"TF:TIN", (int)1, (int)150, (float)4.5f, (float)1.0f, (int)7);
    public static final Item.ToolMaterial TOOL_MATERIAL_SILVER = EnumHelper.addToolMaterial((String)"TF:SILVER", (int)1, (int)75, (float)6.0f, (float)1.0f, (int)25);
    public static final Item.ToolMaterial TOOL_MATERIAL_LEAD = EnumHelper.addToolMaterial((String)"TF:LEAD", (int)1, (int)100, (float)5.0f, (float)1.0f, (int)9);
    public static final Item.ToolMaterial TOOL_MATERIAL_ALUMINUM = EnumHelper.addToolMaterial((String)"TF:ALUMINUM", (int)1, (int)225, (float)10.0f, (float)1.0f, (int)14);
    public static final Item.ToolMaterial TOOL_MATERIAL_NICKEL = EnumHelper.addToolMaterial((String)"TF:NICKEL", (int)2, (int)300, (float)6.5f, (float)2.5f, (int)18);
    public static final Item.ToolMaterial TOOL_MATERIAL_PLATINUM = EnumHelper.addToolMaterial((String)"TF:PLATINUM", (int)4, (int)1400, (float)9.0f, (float)3.5f, (int)16);
    public static final Item.ToolMaterial TOOL_MATERIAL_STEEL = EnumHelper.addToolMaterial((String)"TF:STEEL", (int)2, (int)400, (float)6.5f, (float)2.5f, (int)10);
    public static final Item.ToolMaterial TOOL_MATERIAL_ELECTRUM = EnumHelper.addToolMaterial((String)"TF:ELECTRUM", (int)0, (int)100, (float)14.0f, (float)0.5f, (int)30);
    public static final Item.ToolMaterial TOOL_MATERIAL_INVAR = EnumHelper.addToolMaterial((String)"TF:INVAR", (int)2, (int)425, (float)6.5f, (float)2.5f, (int)12);
    public static final Item.ToolMaterial TOOL_MATERIAL_BRONZE = EnumHelper.addToolMaterial((String)"TF:BRONZE", (int)2, (int)325, (float)6.0f, (float)2.0f, (int)10);
    public static final Item.ToolMaterial TOOL_MATERIAL_CONSTANTAN = EnumHelper.addToolMaterial((String)"TF:CONSTANTAN", (int)2, (int)275, (float)6.0f, (float)1.5f, (int)12);
    public static final HorseArmorType HORSE_ARMOR_COPPER = EnumHelper.addHorseArmor((String)"TF:COPPER", (String)"thermalfoundation:textures/horse_armor/copper.png", (int)4);
    public static final HorseArmorType HORSE_ARMOR_TIN = EnumHelper.addHorseArmor((String)"TF:TIN", (String)"thermalfoundation:textures/horse_armor/tin.png", (int)4);
    public static final HorseArmorType HORSE_ARMOR_SILVER = EnumHelper.addHorseArmor((String)"TF:SILVER", (String)"thermalfoundation:textures/horse_armor/silver.png", (int)8);
    public static final HorseArmorType HORSE_ARMOR_LEAD = EnumHelper.addHorseArmor((String)"TF:LEAD", (String)"thermalfoundation:textures/horse_armor/lead.png", (int)5);
    public static final HorseArmorType HORSE_ARMOR_ALUMINUM = EnumHelper.addHorseArmor((String)"TF:ALUMINUM", (String)"thermalfoundation:textures/horse_armor/aluminum.png", (int)5);
    public static final HorseArmorType HORSE_ARMOR_NICKEL = EnumHelper.addHorseArmor((String)"TF:NICKEL", (String)"thermalfoundation:textures/horse_armor/nickel.png", (int)9);
    public static final HorseArmorType HORSE_ARMOR_PLATINUM = EnumHelper.addHorseArmor((String)"TF:PLATINUM", (String)"thermalfoundation:textures/horse_armor/platinum.png", (int)12);
    public static final HorseArmorType HORSE_ARMOR_STEEL = EnumHelper.addHorseArmor((String)"TF:STEEL", (String)"thermalfoundation:textures/horse_armor/steel.png", (int)9);
    public static final HorseArmorType HORSE_ARMOR_ELECTRUM = EnumHelper.addHorseArmor((String)"TF:ELECTRUM", (String)"thermalfoundation:textures/horse_armor/electrum.png", (int)8);
    public static final HorseArmorType HORSE_ARMOR_INVAR = EnumHelper.addHorseArmor((String)"TF:INVAR", (String)"thermalfoundation:textures/horse_armor/invar.png", (int)9);
    public static final HorseArmorType HORSE_ARMOR_BRONZE = EnumHelper.addHorseArmor((String)"TF:BRONZE", (String)"thermalfoundation:textures/horse_armor/bronze.png", (int)8);
    public static final HorseArmorType HORSE_ARMOR_CONSTANTAN = EnumHelper.addHorseArmor((String)"TF:CONSTANTAN", (String)"thermalfoundation:textures/horse_armor/constantan.png", (int)8);

    private TFEquipment() {
    }

    public static void preInit() {
        for (ArmorSet armorSet : ArmorSet.values()) {
            armorSet.preInit();
            ThermalFoundation.proxy.addIModelRegister(armorSet);
        }
        for (Enum enum_ : ToolSet.values()) {
            ((ToolSet)enum_).preInit();
            ThermalFoundation.proxy.addIModelRegister((IModelRegister)enum_);
        }
        for (Enum enum_ : ToolSetVanilla.values()) {
            ((ToolSetVanilla)enum_).preInit();
            ThermalFoundation.proxy.addIModelRegister((IModelRegister)enum_);
        }
        for (Enum enum_ : HorseArmor.values()) {
            ((HorseArmor)enum_).preInit();
            ThermalFoundation.proxy.addIModelRegister((IModelRegister)enum_);
        }
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (ArmorSet armorSet : ArmorSet.values()) {
            armorSet.initialize();
        }
        for (Enum enum_ : ToolSet.values()) {
            ((ToolSet)enum_).initialize();
        }
        for (Enum enum_ : ToolSetVanilla.values()) {
            ((ToolSetVanilla)enum_).initialize();
        }
        for (Enum enum_ : HorseArmor.values()) {
            ((HorseArmor)enum_).initialize();
        }
    }

    public static enum HorseArmor implements IModelRegister
    {
        COPPER("copper", HORSE_ARMOR_COPPER, "ingotCopper"),
        TIN("tin", HORSE_ARMOR_TIN, "ingotTin"),
        SILVER("silver", HORSE_ARMOR_SILVER, "ingotSilver"),
        LEAD("lead", HORSE_ARMOR_LEAD, "ingotLead"),
        ALUMINUM("aluminum", HORSE_ARMOR_ALUMINUM, "ingotAluminum"),
        NICKEL("nickel", HORSE_ARMOR_NICKEL, "ingotNickel"),
        PLATINUM("platinum", HORSE_ARMOR_PLATINUM, "ingotPlatinum"),
        STEEL("steel", HORSE_ARMOR_STEEL, "ingotSteel"),
        ELECTRUM("electrum", HORSE_ARMOR_ELECTRUM, "ingotElectrum"),
        INVAR("invar", HORSE_ARMOR_INVAR, "ingotInvar"),
        BRONZE("bronze", HORSE_ARMOR_BRONZE, "ingotBronze"),
        CONSTANTAN("constantan", HORSE_ARMOR_CONSTANTAN, "ingotConstantan");

        public final String name;
        public final String ingot;
        public final HorseArmorType ARMOR_TYPE;
        public ItemHorseArmorCore itemArmor;
        public ItemStack armor;
        public boolean enable;

        private HorseArmor(String name, HorseArmorType type, String ingot) {
            this.name = name.toLowerCase(Locale.US);
            this.ingot = ingot;
            this.ARMOR_TYPE = type;
        }

        protected void preInit() {
            String ARMOR = "thermalfoundation.horseArmor." + this.name;
            String category = "Items.HorseArmor";
            this.enable = ThermalFoundation.CONFIG.getConfiguration().get(category, StringHelper.titleCase((String)this.name), true).getBoolean(true);
            this.enable &= TFProps.enableHorseArmorCrafting;
            this.itemArmor = new ItemHorseArmorCore(this.ARMOR_TYPE);
            this.itemArmor.func_77655_b(ARMOR).func_77637_a(CreativeTabs.field_78026_f);
            this.itemArmor.setShowInCreative(this.enable);
            this.itemArmor.setRegistryName("horse_armor_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemArmor);
            this.armor = new ItemStack((Item)this.itemArmor);
        }

        protected void initialize() {
            if (this.enable) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armor, (Object[])new Object[]{"I I", "LCL", "I I", Character.valueOf('C'), "blockWool", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), this.ingot});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("thermalfoundation:horse_armor", "type=" + stackName));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            this.registerModel((Item)this.itemArmor, "horse_armor_" + this.name);
        }
    }

    public static enum ToolSetVanilla implements IModelRegister
    {
        WOOD("wood", Item.ToolMaterial.WOOD, "plankWood"){

            @Override
            protected void create() {
                this.itemBow = Items.field_151031_f;
                this.itemFishingRod = Items.field_151112_aM;
                this.itemShears = new ItemShearsCore(this.material);
                this.itemSickle = new ItemSickleCore(this.material);
                this.itemHammer = new ItemHammerCore(this.material);
                this.itemExcavator = new ItemExcavatorCore(this.material);
                this.itemShield = Items.field_185159_cQ;
            }
        }
        ,
        STONE("stone", Item.ToolMaterial.STONE, "cobblestone"),
        IRON("iron", Item.ToolMaterial.IRON, "ingotIron"){

            @Override
            protected void create() {
                this.itemBow = new ItemBowCore(this.material);
                this.itemFishingRod = new ItemFishingRodCore(this.material);
                this.itemShears = Items.field_151097_aZ;
                this.itemSickle = new ItemSickleCore(this.material);
                this.itemHammer = new ItemHammerCore(this.material);
                this.itemExcavator = new ItemExcavatorCore(this.material);
                this.itemShield = new ItemShieldCore(this.material);
            }
        }
        ,
        DIAMOND("diamond", Item.ToolMaterial.DIAMOND, "gemDiamond"),
        GOLD("gold", Item.ToolMaterial.GOLD, "ingotGold");

        public final String name;
        public final String ingot;
        public final Item.ToolMaterial material;
        private float arrowSpeed;
        private float arrowDamage;
        private float zoomMultiplier = 0.15f;
        private int luckModifier;
        private int speedModifier;
        public ItemBow itemBow;
        public ItemFishingRod itemFishingRod;
        public ItemShears itemShears;
        public ItemSickleCore itemSickle;
        public ItemHammerCore itemHammer;
        public ItemExcavatorCore itemExcavator;
        public Item itemShield;
        public ItemStack toolBow;
        public ItemStack toolFishingRod;
        public ItemStack toolShears;
        public ItemStack toolSickle;
        public ItemStack toolHammer;
        public ItemStack toolExcavator;
        public ItemStack toolShield;
        public boolean[] enable = new boolean[7];

        private ToolSetVanilla(String name, Item.ToolMaterial materialIn, String ingot) {
            this.name = name.toLowerCase(Locale.US);
            this.ingot = ingot;
            this.material = materialIn;
            this.arrowDamage = this.material.func_78000_c() / 4.0f;
            this.arrowSpeed = this.material.func_77998_b() / 20.0f;
            this.zoomMultiplier = MathHelper.clamp((float)(this.material.func_77998_b() / 30.0f), (float)0.0f, (float)(this.zoomMultiplier * 2.0f));
            this.luckModifier = this.material.func_77996_d() / 2;
            this.speedModifier = (int)this.material.func_77998_b() / 3;
        }

        protected void create() {
            this.itemBow = new ItemBowCore(this.material);
            this.itemFishingRod = new ItemFishingRodCore(this.material);
            this.itemShears = new ItemShearsCore(this.material);
            this.itemSickle = new ItemSickleCore(this.material);
            this.itemHammer = new ItemHammerCore(this.material);
            this.itemExcavator = new ItemExcavatorCore(this.material);
            this.itemShield = new ItemShieldCore(this.material);
        }

        protected boolean enableDefault(ToolSetVanilla type) {
            return type != WOOD && type != STONE;
        }

        protected void preInit() {
            String TOOL = "thermalfoundation.tool." + this.name;
            String category = "Equipment.Tool." + StringHelper.titleCase((String)this.name);
            if (this != WOOD) {
                this.enable[0] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Bow", this.enableDefault(this)).getBoolean(this.enableDefault(this)) & !TFProps.disableAllBows;
                this.enable[1] = ThermalFoundation.CONFIG.getConfiguration().get(category, "FishingRod", this.enableDefault(this)).getBoolean(this.enableDefault(this)) & !TFProps.disableAllFishingRods;
            }
            if (this != IRON) {
                this.enable[2] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Shears", this.enableDefault(this)).getBoolean(this.enableDefault(this)) & !TFProps.disableAllShears;
            }
            this.enable[3] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Sickle", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            this.enable[4] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Hammer", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            this.enable[5] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Excavator", this.enableDefault(this)).getBoolean(this.enableDefault(this));
            if (this != WOOD) {
                this.enable[6] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Shield", this.enableDefault(this)).getBoolean(this.enableDefault(this)) & !TFProps.disableAllShields;
            }
            for (int i = 0; i < this.enable.length; ++i) {
                int n = i;
                this.enable[n] = this.enable[n] & !TFProps.disableAllTools;
                int n2 = i;
                this.enable[n2] = this.enable[n2] & !TFProps.disableVanillaTools;
            }
            this.create();
            if (this.itemBow instanceof ItemBowCore) {
                ItemBowCore itemBow = (ItemBowCore)this.itemBow;
                itemBow.setRepairIngot(this.ingot).func_77655_b(TOOL + "Bow").func_77637_a(CreativeTabs.field_78037_j);
                itemBow.setArrowDamage(this.arrowDamage).setArrowSpeed(this.arrowSpeed).setZoomMultiplier(this.zoomMultiplier);
                itemBow.setShowInCreative(this.enable[0] | TFProps.showDisabledEquipment);
                itemBow.setRegistryName("tool.bow_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBow);
            }
            if (this.itemFishingRod instanceof ItemFishingRodCore) {
                ItemFishingRodCore itemFishingRod = (ItemFishingRodCore)this.itemFishingRod;
                itemFishingRod.setRepairIngot(this.ingot).func_77655_b(TOOL + "FishingRod").func_77637_a(CreativeTabs.field_78040_i);
                itemFishingRod.setLuckModifier(this.luckModifier).setSpeedModifier(this.speedModifier);
                itemFishingRod.setShowInCreative(this.enable[1] | TFProps.showDisabledEquipment);
                itemFishingRod.setRegistryName("tool.fishing_rod_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemFishingRod);
            }
            if (this.itemShears instanceof ItemShearsCore) {
                ItemShearsCore itemShears = (ItemShearsCore)this.itemShears;
                itemShears.setRepairIngot(this.ingot).func_77655_b(TOOL + "Shears").func_77637_a(CreativeTabs.field_78040_i);
                itemShears.setShowInCreative(this.enable[2] | TFProps.showDisabledEquipment);
                itemShears.setRegistryName("tool.shears_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemShears);
            }
            this.itemSickle.setRepairIngot(this.ingot).func_77655_b(TOOL + "Sickle").func_77637_a(CreativeTabs.field_78040_i);
            this.itemSickle.setShowInCreative(this.enable[3] | TFProps.showDisabledEquipment);
            this.itemSickle.setRegistryName("tool.sickle_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemSickle);
            this.itemHammer.setRepairIngot(this.ingot).func_77655_b(TOOL + "Hammer").func_77637_a(CreativeTabs.field_78040_i);
            this.itemHammer.setShowInCreative(this.enable[4] | TFProps.showDisabledEquipment);
            this.itemHammer.setRegistryName("tool.hammer_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemHammer);
            this.itemExcavator.setRepairIngot(this.ingot).func_77655_b(TOOL + "Excavator").func_77637_a(CreativeTabs.field_78040_i);
            this.itemExcavator.setShowInCreative(this.enable[5] | TFProps.showDisabledEquipment);
            this.itemExcavator.setRegistryName("tool.excavator_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemExcavator);
            if (this.itemShield instanceof ItemShieldCore) {
                ((ItemShieldCore)this.itemShield).setRepairIngot(this.ingot).func_77655_b(TOOL + "Shield").func_77637_a(CreativeTabs.field_78037_j);
                ((ItemShieldCore)this.itemShield).setShowInCreative(this.enable[6] | TFProps.showDisabledEquipment);
                this.itemShield.setRegistryName("tool.shield_" + this.name);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemShield);
            }
            this.toolBow = new ItemStack((Item)this.itemBow);
            this.toolFishingRod = new ItemStack((Item)this.itemFishingRod);
            this.toolShears = new ItemStack((Item)this.itemShears);
            this.toolSickle = new ItemStack((Item)this.itemSickle);
            this.toolHammer = new ItemStack((Item)this.itemHammer);
            this.toolExcavator = new ItemStack((Item)this.itemExcavator);
            this.toolShield = new ItemStack(this.itemShield);
        }

        protected void initialize() {
            if (this.enable[0]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolBow, (Object[])new Object[]{" I#", "S #", " I#", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), "string"});
            }
            if (this.enable[1]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolFishingRod, (Object[])new Object[]{"  I", " I#", "S #", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), "string"});
            }
            if (this.enable[2]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShears, (Object[])new Object[]{" I", "I ", Character.valueOf('I'), this.ingot});
            }
            if (this.enable[3]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolSickle, (Object[])new Object[]{" I ", "  I", "SI ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[4]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolHammer, (Object[])new Object[]{"III", "ISI", " S ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[5]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolExcavator, (Object[])new Object[]{" I ", "ISI", " S ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[6]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShield, (Object[])new Object[]{"III", "ISI", " I ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), Items.field_185159_cQ});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("thermalfoundation:tool", "type=" + stackName));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModelOverride(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("thermalfoundation:tool/" + stackName, "inventory"));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            if (this.itemBow instanceof ItemBowCore) {
                this.registerModelOverride((Item)this.itemBow, "bow_" + this.name);
            }
            if (this.itemFishingRod instanceof ItemFishingRodCore) {
                this.registerModelOverride((Item)this.itemFishingRod, "fishing_rod_" + this.name);
            }
            if (this.itemShears instanceof ItemShearsCore) {
                this.registerModel((Item)this.itemShears, "shears_" + this.name);
            }
            this.registerModel((Item)this.itemSickle, "sickle_" + this.name);
            this.registerModel((Item)this.itemHammer, "hammer_" + this.name);
            this.registerModel((Item)this.itemExcavator, "excavator_" + this.name);
            if (this.itemShield instanceof ItemShieldCore) {
                this.registerModelOverride(this.itemShield, "shield_" + this.name);
            }
        }
    }

    public static enum ToolSet implements IModelRegister
    {
        COPPER("copper", TOOL_MATERIAL_COPPER, "ingotCopper"),
        TIN("tin", TOOL_MATERIAL_TIN, "ingotTin"),
        SILVER("silver", TOOL_MATERIAL_SILVER, "ingotSilver"),
        LEAD("lead", TOOL_MATERIAL_LEAD, "ingotLead"),
        ALUMINUM("aluminum", TOOL_MATERIAL_ALUMINUM, "ingotAluminum"),
        NICKEL("nickel", TOOL_MATERIAL_NICKEL, "ingotNickel"),
        PLATINUM("platinum", TOOL_MATERIAL_PLATINUM, "ingotPlatinum"),
        STEEL("steel", TOOL_MATERIAL_STEEL, "ingotSteel"),
        ELECTRUM("electrum", TOOL_MATERIAL_ELECTRUM, "ingotElectrum"),
        INVAR("invar", TOOL_MATERIAL_INVAR, "ingotInvar"),
        BRONZE("bronze", TOOL_MATERIAL_BRONZE, "ingotBronze"),
        CONSTANTAN("constantan", TOOL_MATERIAL_CONSTANTAN, "ingotConstantan");

        public final String name;
        public final String ingot;
        public final Item.ToolMaterial material;
        private float arrowDamage;
        private float arrowSpeed;
        private float zoomMultiplier = 0.15f;
        private int luckModifier;
        private int speedModifier;
        public ItemSwordCore itemSword;
        public ItemShovelCore itemShovel;
        public ItemPickaxeCore itemPickaxe;
        public ItemAxeCore itemAxe;
        public ItemHoeCore itemHoe;
        public ItemBowCore itemBow;
        public ItemFishingRodCore itemFishingRod;
        public ItemShearsCore itemShears;
        public ItemSickleCore itemSickle;
        public ItemHammerCore itemHammer;
        public ItemExcavatorCore itemExcavator;
        public ItemShieldCore itemShield;
        public ItemStack toolSword;
        public ItemStack toolShovel;
        public ItemStack toolPickaxe;
        public ItemStack toolAxe;
        public ItemStack toolHoe;
        public ItemStack toolBow;
        public ItemStack toolFishingRod;
        public ItemStack toolShears;
        public ItemStack toolSickle;
        public ItemStack toolHammer;
        public ItemStack toolExcavator;
        public ItemStack toolShield;
        public boolean[] enable = new boolean[12];

        private ToolSet(String name, Item.ToolMaterial materialIn, String ingot) {
            this.name = name.toLowerCase(Locale.US);
            this.ingot = ingot;
            this.material = materialIn;
            this.arrowDamage = this.material.func_78000_c() / 4.0f;
            this.arrowSpeed = this.material.func_77998_b() / 20.0f;
            this.zoomMultiplier = MathHelper.clamp((float)(this.material.func_77998_b() / 30.0f), (float)this.zoomMultiplier, (float)(this.zoomMultiplier * 2.0f));
            this.luckModifier = this.material.func_77996_d() / 2;
            this.speedModifier = (int)this.material.func_77998_b() / 3;
        }

        protected void create() {
            this.itemSword = new ItemSwordCore(this.material);
            this.itemShovel = new ItemShovelCore(this.material);
            this.itemPickaxe = new ItemPickaxeCore(this.material);
            this.itemAxe = new ItemAxeCore(this.material);
            this.itemHoe = new ItemHoeCore(this.material);
            this.itemBow = new ItemBowCore(this.material);
            this.itemFishingRod = new ItemFishingRodCore(this.material);
            this.itemShears = new ItemShearsCore(this.material);
            this.itemSickle = new ItemSickleCore(this.material);
            this.itemHammer = new ItemHammerCore(this.material);
            this.itemExcavator = new ItemExcavatorCore(this.material);
            this.itemShield = new ItemShieldCore(this.material);
        }

        protected void preInit() {
            String TOOL = "thermalfoundation.tool." + this.name;
            String category = "Equipment.Tools." + StringHelper.titleCase((String)this.name);
            this.enable[0] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Sword", true).getBoolean(true);
            this.enable[1] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Shovel", true).getBoolean(true);
            this.enable[2] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Pickaxe", true).getBoolean(true);
            this.enable[3] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Axe", true).getBoolean(true);
            this.enable[4] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Hoe", true).getBoolean(true);
            this.enable[5] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Bow", true).getBoolean(true) & !TFProps.disableAllBows;
            this.enable[6] = ThermalFoundation.CONFIG.getConfiguration().get(category, "FishingRod", true).getBoolean(true) & !TFProps.disableAllFishingRods;
            this.enable[7] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Shears", true).getBoolean(true) & !TFProps.disableAllShears;
            this.enable[8] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Sickle", true).getBoolean(true);
            this.enable[9] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Hammer", true).getBoolean(true);
            this.enable[10] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Excavator", true).getBoolean(true);
            this.enable[11] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Shield", true).getBoolean(true) & !TFProps.disableAllShields;
            for (int i = 0; i < this.enable.length; ++i) {
                int n = i;
                this.enable[n] = this.enable[n] & !TFProps.disableAllTools;
            }
            this.create();
            this.itemSword.setRepairIngot(this.ingot).func_77655_b(TOOL + "Sword").func_77637_a(ThermalFoundation.tabBasicCombat);
            this.itemSword.setShowInCreative(this.enable[0] | TFProps.showDisabledEquipment);
            this.itemSword.setRegistryName("tool.sword_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemSword);
            this.itemShovel.setRepairIngot(this.ingot).func_77655_b(TOOL + "Shovel").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemShovel.setShowInCreative(this.enable[1] | TFProps.showDisabledEquipment);
            this.itemShovel.setRegistryName("tool.shovel_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemShovel);
            this.itemPickaxe.setRepairIngot(this.ingot).func_77655_b(TOOL + "Pickaxe").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemPickaxe.setShowInCreative(this.enable[2] | TFProps.showDisabledEquipment);
            this.itemPickaxe.setRegistryName("tool.pickaxe_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemPickaxe);
            this.itemAxe.setRepairIngot(this.ingot).func_77655_b(TOOL + "Axe").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemAxe.setShowInCreative(this.enable[3] | TFProps.showDisabledEquipment);
            this.itemAxe.setRegistryName("tool.axe_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemAxe);
            this.itemHoe.setRepairIngot(this.ingot).func_77655_b(TOOL + "Hoe").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemHoe.setShowInCreative(this.enable[4] | TFProps.showDisabledEquipment);
            this.itemHoe.setRegistryName("tool.hoe_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemHoe);
            this.itemBow.setRepairIngot(this.ingot).func_77655_b(TOOL + "Bow").func_77637_a(ThermalFoundation.tabBasicCombat);
            this.itemBow.setArrowDamage(this.arrowDamage).setArrowSpeed(this.arrowSpeed).setZoomMultiplier(this.zoomMultiplier);
            this.itemBow.setShowInCreative(this.enable[5] | TFProps.showDisabledEquipment);
            this.itemBow.setRegistryName("tool.bow_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemBow);
            this.itemFishingRod.setRepairIngot(this.ingot).func_77655_b(TOOL + "FishingRod").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemFishingRod.setLuckModifier(this.luckModifier).setSpeedModifier(this.speedModifier);
            this.itemFishingRod.setShowInCreative(this.enable[6]);
            this.itemFishingRod.setRegistryName("tool.fishing_rod_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemFishingRod);
            this.itemShears.setRepairIngot(this.ingot).func_77655_b(TOOL + "Shears").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemShears.setShowInCreative(this.enable[7] | TFProps.showDisabledEquipment);
            this.itemShears.setRegistryName("tool.shears_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemShears);
            this.itemSickle.setRepairIngot(this.ingot).func_77655_b(TOOL + "Sickle").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemSickle.setShowInCreative(this.enable[8] | TFProps.showDisabledEquipment);
            this.itemSickle.setRegistryName("tool.sickle_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemSickle);
            this.itemHammer.setRepairIngot(this.ingot).func_77655_b(TOOL + "Hammer").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemHammer.setShowInCreative(this.enable[9] | TFProps.showDisabledEquipment);
            this.itemHammer.setRegistryName("tool.hammer_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemHammer);
            this.itemExcavator.setRepairIngot(this.ingot).func_77655_b(TOOL + "Excavator").func_77637_a(ThermalFoundation.tabBasicTools);
            this.itemExcavator.setShowInCreative(this.enable[10] | TFProps.showDisabledEquipment);
            this.itemExcavator.setRegistryName("tool.excavator_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemExcavator);
            this.itemShield.setRepairIngot(this.ingot).func_77655_b(TOOL + "Shield").func_77637_a(ThermalFoundation.tabBasicCombat);
            this.itemShield.setShowInCreative(this.enable[11] | TFProps.showDisabledEquipment);
            this.itemShield.setRegistryName("tool.shield_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemShield);
            this.toolSword = new ItemStack((Item)this.itemSword);
            this.toolShovel = new ItemStack((Item)this.itemShovel);
            this.toolPickaxe = new ItemStack((Item)this.itemPickaxe);
            this.toolAxe = new ItemStack((Item)this.itemAxe);
            this.toolHoe = new ItemStack((Item)this.itemHoe);
            this.toolBow = new ItemStack((Item)this.itemBow);
            this.toolFishingRod = new ItemStack((Item)this.itemFishingRod);
            this.toolShears = new ItemStack((Item)this.itemShears);
            this.toolSickle = new ItemStack((Item)this.itemSickle);
            this.toolHammer = new ItemStack((Item)this.itemHammer);
            this.toolExcavator = new ItemStack((Item)this.itemExcavator);
            this.toolShield = new ItemStack((Item)this.itemShield);
        }

        protected void initialize() {
            if (this.enable[0]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolSword, (Object[])new Object[]{"I", "I", "S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[1]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShovel, (Object[])new Object[]{"I", "S", "S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[2]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolPickaxe, (Object[])new Object[]{"III", " S ", " S ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[3]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolAxe, (Object[])new Object[]{"II", "IS", " S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[4]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolHoe, (Object[])new Object[]{"II", " S", " S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[5]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolBow, (Object[])new Object[]{" I#", "S #", " I#", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), "string"});
            }
            if (this.enable[6]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolFishingRod, (Object[])new Object[]{"  I", " I#", "S #", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), "string"});
            }
            if (this.enable[7]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShears, (Object[])new Object[]{" I", "I ", Character.valueOf('I'), this.ingot});
            }
            if (this.enable[8]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolSickle, (Object[])new Object[]{" I ", "  I", "SI ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[9]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolHammer, (Object[])new Object[]{"III", "ISI", " S ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[10]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolExcavator, (Object[])new Object[]{" I ", "ISI", " S ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"});
            }
            if (this.enable[11]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShield, (Object[])new Object[]{"III", "ISI", " I ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), Items.field_185159_cQ});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("thermalfoundation:tool", "type=" + stackName));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModelOverride(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("thermalfoundation:tool/" + stackName, "inventory"));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            this.registerModel((Item)this.itemSword, "sword_" + this.name);
            this.registerModel((Item)this.itemShovel, "shovel_" + this.name);
            this.registerModel((Item)this.itemPickaxe, "pickaxe_" + this.name);
            this.registerModel((Item)this.itemAxe, "axe_" + this.name);
            this.registerModel((Item)this.itemHoe, "hoe_" + this.name);
            this.registerModelOverride((Item)this.itemBow, "bow_" + this.name);
            this.registerModelOverride((Item)this.itemFishingRod, "fishing_rod_" + this.name);
            this.registerModel((Item)this.itemShears, "shears_" + this.name);
            this.registerModel((Item)this.itemSickle, "sickle_" + this.name);
            this.registerModel((Item)this.itemHammer, "hammer_" + this.name);
            this.registerModel((Item)this.itemExcavator, "excavator_" + this.name);
            this.registerModelOverride((Item)this.itemShield, "shield_" + this.name);
        }
    }

    public static enum ArmorSet implements IModelRegister
    {
        COPPER("copper", ARMOR_MATERIAL_COPPER, "ingotCopper"),
        TIN("tin", ARMOR_MATERIAL_TIN, "ingotTin"),
        SILVER("silver", ARMOR_MATERIAL_SILVER, "ingotSilver"),
        LEAD("lead", ARMOR_MATERIAL_LEAD, "ingotLead"),
        ALUMINUM("aluminum", ARMOR_MATERIAL_ALUMINUM, "ingotAluminum"),
        NICKEL("nickel", ARMOR_MATERIAL_NICKEL, "ingotNickel"),
        PLATINUM("platinum", ARMOR_MATERIAL_PLATINUM, "ingotPlatinum"),
        STEEL("steel", ARMOR_MATERIAL_STEEL, "ingotSteel"),
        ELECTRUM("electrum", ARMOR_MATERIAL_ELECTRUM, "ingotElectrum"),
        INVAR("invar", ARMOR_MATERIAL_INVAR, "ingotInvar"),
        BRONZE("bronze", ARMOR_MATERIAL_BRONZE, "ingotBronze"),
        CONSTANTAN("constantan", ARMOR_MATERIAL_CONSTANTAN, "ingotConstantan");

        public final String name;
        public final String ingot;
        public final ItemArmor.ArmorMaterial ARMOR_MATERIAL;
        public ItemArmorCore itemHelmet;
        public ItemArmorCore itemChestplate;
        public ItemArmorCore itemLegs;
        public ItemArmorCore itemBoots;
        public ItemStack armorHelmet;
        public ItemStack armorChestplate;
        public ItemStack armorLegs;
        public ItemStack armorBoots;
        public boolean[] enable = new boolean[4];

        private ArmorSet(String name, ItemArmor.ArmorMaterial material, String ingot) {
            this.name = name.toLowerCase(Locale.US);
            this.ingot = ingot;
            this.ARMOR_MATERIAL = material;
        }

        protected void create() {
            this.itemHelmet = new ItemArmorCore(this.ARMOR_MATERIAL, EntityEquipmentSlot.HEAD);
            this.itemChestplate = new ItemArmorCore(this.ARMOR_MATERIAL, EntityEquipmentSlot.CHEST);
            this.itemLegs = new ItemArmorCore(this.ARMOR_MATERIAL, EntityEquipmentSlot.LEGS);
            this.itemBoots = new ItemArmorCore(this.ARMOR_MATERIAL, EntityEquipmentSlot.FEET);
        }

        protected void preInit() {
            String ARMOR = "thermalfoundation.armor." + this.name;
            String PATH_ARMOR = "thermalfoundation:textures/armor/";
            String[] TEXTURE = new String[]{"thermalfoundation:textures/armor/" + this.name + "_1.png", "thermalfoundation:textures/armor/" + this.name + "_2.png"};
            String category = "Equipment.Armor." + StringHelper.titleCase((String)this.name);
            this.enable[0] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Helmet", true).getBoolean(true);
            this.enable[1] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Chestplate", true).getBoolean(true);
            this.enable[2] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Leggings", true).getBoolean(true);
            this.enable[3] = ThermalFoundation.CONFIG.getConfiguration().get(category, "Boots", true).getBoolean(true);
            for (int i = 0; i < this.enable.length; ++i) {
                int n = i;
                this.enable[n] = this.enable[n] & !TFProps.disableAllArmor;
            }
            this.create();
            this.itemHelmet.setArmorTextures(TEXTURE).setRepairIngot(this.ingot).func_77655_b(ARMOR + "Helmet").func_77637_a(ThermalFoundation.tabBasicArmor);
            this.itemHelmet.setShowInCreative(this.enable[0]);
            this.itemHelmet.setRegistryName("armor.helmet_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemHelmet);
            this.itemChestplate.setArmorTextures(TEXTURE).setRepairIngot(this.ingot).func_77655_b(ARMOR + "Chestplate").func_77637_a(ThermalFoundation.tabBasicArmor);
            this.itemChestplate.setShowInCreative(this.enable[1]);
            this.itemChestplate.setRegistryName("armor.plate_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemChestplate);
            this.itemLegs.setArmorTextures(TEXTURE).setRepairIngot(this.ingot).func_77655_b(ARMOR + "Legs").func_77637_a(ThermalFoundation.tabBasicArmor);
            this.itemLegs.setShowInCreative(this.enable[2]);
            this.itemLegs.setRegistryName("armor.legs_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemLegs);
            this.itemBoots.setArmorTextures(TEXTURE).setRepairIngot(this.ingot).func_77655_b(ARMOR + "Boots").func_77637_a(ThermalFoundation.tabBasicArmor);
            this.itemBoots.setShowInCreative(this.enable[3]);
            this.itemBoots.setRegistryName("armor.boots_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemBoots);
            this.armorHelmet = new ItemStack((Item)this.itemHelmet);
            this.armorChestplate = new ItemStack((Item)this.itemChestplate);
            this.armorLegs = new ItemStack((Item)this.itemLegs);
            this.armorBoots = new ItemStack((Item)this.itemBoots);
        }

        protected void initialize() {
            if (this.enable[0]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorHelmet, (Object[])new Object[]{"III", "I I", Character.valueOf('I'), this.ingot});
            }
            if (this.enable[1]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorChestplate, (Object[])new Object[]{"I I", "III", "III", Character.valueOf('I'), this.ingot});
            }
            if (this.enable[2]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorLegs, (Object[])new Object[]{"III", "I I", "I I", Character.valueOf('I'), this.ingot});
            }
            if (this.enable[3]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorBoots, (Object[])new Object[]{"I I", "I I", Character.valueOf('I'), this.ingot});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("thermalfoundation:armor", "type=" + stackName));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            this.registerModel((Item)this.itemHelmet, "helmet_" + this.name);
            this.registerModel((Item)this.itemChestplate, "chestplate_" + this.name);
            this.registerModel((Item)this.itemLegs, "leggings_" + this.name);
            this.registerModel((Item)this.itemBoots, "boots_" + this.name);
        }
    }
}

