/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client.highlight;

import codechicken.lib.command.ClientCommandBase;
import codechicken.lib.command.help.IBetterHelpCommand;
import codechicken.lib.internal.HighlightHandler;
import codechicken.lib.raytracer.RayTracer;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class HighlightSetCommand
extends ClientCommandBase
implements IBetterHelpCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Minecraft mc, EntityPlayerSP player, String[] args) throws CommandException {
        BlockPos newPos;
        BlockPos prev = HighlightHandler.highlight;
        if (args.length == 0) {
            RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, 3000.0);
            if (traceResult == null || traceResult.field_72313_a != RayTraceResult.Type.BLOCK) throw new CommandException("Not looking at something within 3000 blocks.", new Object[0]);
            newPos = traceResult.func_178782_a();
        } else {
            if (args.length != 3) throw new CommandException("Please specify 3 arguments for manual, or 0 for look.", new Object[0]);
            newPos = HighlightSetCommand.func_175757_a((ICommandSender)player, (String[])args, (int)0, (boolean)false);
        }
        HighlightHandler.highlight = newPos;
        if (prev != null) {
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Moved highlight from %s, %s, %s to %s, %s, %s", prev.func_177958_n(), prev.func_177956_o(), prev.func_177952_p(), newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p())));
            return;
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Set highlight at %s, %s, %s", newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p())));
        }
    }

    public int func_82362_a() {
        return 0;
    }

    @Override
    public String getDesc() {
        return "Set the location for the highlight overlay.";
    }

    @Override
    public List<String> getHelp() {
        return Collections.singletonList(this.getDesc());
    }

    public String func_71517_b() {
        return "set";
    }
}

