/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryCopy
implements IInventory {
    public boolean[] accessible;
    public ItemStack[] items;
    public IInventory inv;

    public InventoryCopy(IInventory inv) {
        this.items = new ItemStack[inv.func_70302_i_()];
        ArrayUtils.fillArray(this.items, ItemStack.field_190927_a, Objects::isNull);
        this.accessible = new boolean[inv.func_70302_i_()];
        this.inv = inv;
        this.update();
    }

    public void update() {
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.items[i] = stack.func_77946_l();
        }
    }

    public InventoryCopy open(InventoryRange access) {
        int lslot = access.lastSlot();
        if (lslot > this.accessible.length) {
            boolean[] l_accessible = new boolean[lslot];
            ItemStack[] l_items = new ItemStack[lslot];
            System.arraycopy(this.accessible, 0, l_accessible, 0, this.accessible.length);
            System.arraycopy(this.items, 0, l_items, 0, this.items.length);
            this.accessible = l_accessible;
            this.items = l_items;
        }
        for (int slot : access.slots) {
            this.accessible[slot] = true;
        }
        return this;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public boolean func_191420_l() {
        return ArrayUtils.count(this.items, stack -> !stack.func_190926_b()) <= 0;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.items[slot] = stack;
        this.func_70296_d();
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return this.inv.func_94041_b(i, itemstack);
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Nonnull
    public String func_70005_c_() {
        return "copy";
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }
}

