/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiSearchUpgradeOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderSearchItemBlock;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;

public class SearchUpgradeHandler
implements IUpgradeRenderHandler {
    private int totalSearchedItemCount;
    private int itemSearchCount;
    private int ticksExisted;
    private final Map<EntityItem, Integer> searchedItems = new HashMap<EntityItem, Integer>();
    private final Map<BlockPos, RenderSearchItemBlock> trackedInventories = new HashMap<BlockPos, RenderSearchItemBlock>();
    @SideOnly(value=Side.CLIENT)
    private GuiAnimatedStat searchInfo;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return "itemSearcher";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        ++this.ticksExisted;
        if ((this.ticksExisted & 0xF) == 0) {
            int blockSearchCount = this.trackInventoryCounts(rangeUpgrades);
            this.searchedItems.entrySet().removeIf(e -> !((EntityItem)e.getKey()).func_70089_S());
            this.totalSearchedItemCount = this.itemSearchCount + blockSearchCount;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(Textures.GLOW_RESOURCE);
        this.searchedItems.forEach((item, value) -> {
            float height = MathHelper.func_76126_a((float)(((float)item.func_174872_o() + partialTicks) / 10.0f + item.field_70290_d)) * 0.1f + 0.2f;
            RenderSearchItemBlock.renderSearch(item.field_70142_S + (item.field_70165_t - item.field_70142_S) * (double)partialTicks, item.field_70137_T + (item.field_70163_u - item.field_70137_T) * (double)partialTicks + (double)height, item.field_70136_U + (item.field_70161_v - item.field_70136_U) * (double)partialTicks, value, this.totalSearchedItemCount, partialTicks);
        });
        this.trackedInventories.values().forEach(entry -> entry.renderSearchBlock(this.totalSearchedItemCount, partialTicks));
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean helmetEnabled) {
        ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(ClientUtils.getWornArmor(EntityEquipmentSlot.HEAD));
        ArrayList<String> textList = new ArrayList<String>();
        if (searchStack.func_190926_b()) {
            textList.add("press '" + Keyboard.getKeyName((int)KeyHandler.getInstance().keybindOpenOptions.func_151463_i()) + "' to configure");
        } else {
            textList.add(searchStack.func_82833_r() + " (" + this.totalSearchedItemCount + " found)");
        }
        this.searchInfo.setText(textList);
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.SEARCH)};
    }

    private int trackInventoryCounts(int rangeUpgrades) {
        int blockSearchCount = 0;
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        int blockTrackRangeSq = blockTrackRange * blockTrackRange;
        EntityPlayer player = PneumaticCraftRepressurized.proxy.getClientPlayer();
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, RenderSearchItemBlock> entry : this.trackedInventories.entrySet()) {
            int nItems;
            int n = nItems = entry.getKey().func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) < (double)blockTrackRangeSq ? entry.getValue().getSearchedItemCount() : 0;
            if (nItems == 0) {
                toRemove.add(entry.getKey());
            }
            blockSearchCount += nItems;
        }
        toRemove.forEach(this.trackedInventories::remove);
        return blockSearchCount;
    }

    void trackItemEntities(EntityPlayer player, int rangeUpgrades, boolean handlerEnabled) {
        this.searchedItems.clear();
        this.itemSearchCount = 0;
        if (!handlerEnabled) {
            return;
        }
        ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(ClientUtils.getWornArmor(EntityEquipmentSlot.HEAD));
        List items = player.field_70170_p.func_72872_a(EntityItem.class, EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades));
        for (EntityItem item : items) {
            if (item.func_92059_d().func_190926_b() || searchStack.func_190926_b()) continue;
            if (item.func_92059_d().func_77969_a(searchStack)) {
                this.searchedItems.put(item, item.func_92059_d().func_190916_E());
                this.itemSearchCount += item.func_92059_d().func_190916_E();
                continue;
            }
            List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(item.func_92059_d());
            int itemCount = 0;
            for (ItemStack inventoryItem : inventoryItems) {
                if (!inventoryItem.func_77969_a(searchStack)) continue;
                itemCount += inventoryItem.func_190916_E();
            }
            if (itemCount <= 0) continue;
            this.searchedItems.put(item, itemCount);
            this.itemSearchCount += itemCount;
        }
    }

    void checkInventoryForItems(TileEntity te, EnumFacing face, boolean handlerEnabled) {
        if (!handlerEnabled) {
            this.trackedInventories.clear();
        } else {
            ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(ClientUtils.getWornArmor(EntityEquipmentSlot.HEAD));
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
            if (!searchStack.func_190926_b() && this.checkForItems(handler, searchStack)) {
                this.trackedInventories.put(te.func_174877_v(), new RenderSearchItemBlock(te.func_145831_w(), te.func_174877_v()));
            }
        }
    }

    private boolean checkForItems(IItemHandler handler, ItemStack searchStack) {
        for (int l = 0; l < handler.getSlots(); ++l) {
            int items;
            if (handler.getStackInSlot(l).func_190926_b() || (items = RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), searchStack)) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.trackedInventories.clear();
        this.searchedItems.clear();
        this.ticksExisted = 0;
        this.searchInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiSearchUpgradeOptions(this);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        if (this.searchInfo == null) {
            GuiAnimatedStat.StatIcon icon = GuiAnimatedStat.StatIcon.of(CraftingRegistrator.getUpgrade(IItemRegistry.EnumUpgrade.SEARCH));
            this.searchInfo = new GuiAnimatedStat(null, "Currently searching for:", icon, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.itemSearchStat);
            this.searchInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.searchInfo;
    }

    @Override
    public void onResolutionChanged() {
        this.searchInfo = null;
    }
}

