/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Random;
import me.desht.pneumaticcraft.common.TemporaryBlockManager;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemGunAmmoFreezing
extends ItemGunAmmo {
    public ItemGunAmmoFreezing() {
        super("gun_ammo_freezing");
    }

    @Override
    protected int getCartridgeSize() {
        return ConfigHandler.minigun.freezingAmmoCartridgeSize;
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 4235519;
    }

    @Override
    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        float mul = super.getDamageMultiplier(target, ammoStack);
        if (target != null && target.func_70045_F()) {
            mul = (float)((double)mul * 1.5);
        }
        return mul;
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        double knockback = -1.0;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)target;
            living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, living.func_70681_au().nextInt(40) + 40, 3));
            if (minigun.dispenserWeightedPercentage(ConfigHandler.minigun.freezingAmmoEntityIceChance)) {
                knockback = living.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b();
                living.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                this.encaseInFakeIce(minigun, target);
            }
        }
        if (knockback != -1.0) {
            ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(knockback);
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    private void encaseInFakeIce(Minigun minigun, Entity target) {
        World world = target.field_70170_p;
        Random rnd = world.field_73012_v;
        TemporaryBlockManager mgr = TemporaryBlockManager.getManager(world);
        AxisAlignedBB aabb = target.func_174813_aQ();
        int y = (int)aabb.field_72338_b;
        while ((double)y <= aabb.field_72337_e) {
            int x = (int)Math.floor(aabb.field_72340_a);
            while ((double)x <= aabb.field_72336_d) {
                int z = (int)Math.floor(aabb.field_72339_c);
                while ((double)z <= aabb.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                        mgr.trySetBlock(minigun.getPlayer(), EnumFacing.UP, pos, Blockss.FAKE_ICE.func_176223_P(), 60 + rnd.nextInt(40));
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        World world = minigun.getWorld();
        if (world.field_73011_w.func_186058_p() != DimensionType.NETHER && minigun.dispenserWeightedPercentage(ConfigHandler.minigun.freezingAmmoBlockIceChance)) {
            Vec3d eye;
            RayTraceResult res;
            BlockPos pos1 = world.func_180495_p(pos).func_185917_h() || face != EnumFacing.UP ? pos.func_177972_a(face) : pos;
            IBlockState newState = null;
            if (world.func_175623_d(pos1) && !world.func_175623_d(pos1.func_177977_b())) {
                newState = Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1));
            } else if (world.func_180495_p(pos1).func_177230_c() == Blocks.field_150431_aC) {
                IBlockState state = world.func_180495_p(pos1);
                int level = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                newState = level < 8 ? Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(level + 1)) : Blocks.field_150433_aE.func_176223_P();
            } else if (world.func_180495_p(pos1).func_177230_c() == Blocks.field_150355_j && (res = world.func_147447_a(eye = minigun.getPlayer().func_174824_e(0.0f), hitVec, true, false, false)) != null && res.field_72313_a == RayTraceResult.Type.BLOCK) {
                pos1 = res.func_178782_a();
                newState = Blocks.field_150432_aD.func_176223_P();
            }
            if (newState != null) {
                PneumaticCraftUtils.tryPlaceBlock(world, pos1, minigun.getPlayer(), face, newState);
            }
        }
        return super.onBlockHit(minigun, ammo, pos, face, hitVec);
    }
}

