/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetArea;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTooBigException;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeCylinder;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeGrid;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeLine;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypePyramid;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeRandom;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeSphere;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeWall;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetArea
extends ProgWidget
implements IAreaProvider,
IVariableWidget {
    public int x1;
    public int y1;
    public int z1;
    public int x2;
    public int y2;
    public int z2;
    private String coord1Variable = "";
    private String coord2Variable = "";
    private DroneAIManager aiManager;
    private IVariableProvider variableProvider;
    public AreaType type = new AreaTypeBox();
    private static final Map<String, Supplier<? extends AreaType>> areaTypes = new LinkedHashMap<String, Supplier<? extends AreaType>>();
    private static final Map<Class<? extends AreaType>, String> typeToIDs = new HashMap<Class<? extends AreaType>, String>();
    @Deprecated
    private static final Map<EnumAreaType, String> oldFormatToAreaTypes = new HashMap<EnumAreaType, String>();

    private static <T extends AreaType> void register(String id, Class<T> clazz, Supplier<T> creator, EnumAreaType ... oldTypes) {
        if (areaTypes.containsKey(id)) {
            throw new IllegalStateException("Area type " + clazz + " could not be registered, duplicate id: " + id);
        }
        areaTypes.put(id, creator);
        typeToIDs.put(clazz, id);
        for (EnumAreaType oldType : oldTypes) {
            oldFormatToAreaTypes.put(oldType, id);
        }
    }

    public static List<AreaType> getAllAreaTypes() {
        return areaTypes.values().stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static ProgWidgetArea fromPosition(BlockPos p1) {
        return ProgWidgetArea.fromPositions(p1, p1);
    }

    public static ProgWidgetArea fromPosAndExpansions(BlockPos p1, int expX, int expY, int expZ) {
        int x = expX / 2;
        int y = expY / 2;
        int z = expZ / 2;
        return ProgWidgetArea.fromPositions(p1.func_177982_a(-x, -y, -z), p1.func_177982_a(x, y, z));
    }

    public static ProgWidgetArea fromPositions(BlockPos p1, BlockPos p2) {
        ProgWidgetArea area = new ProgWidgetArea();
        area.setP1(p1);
        area.setP2(p2);
        return area;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        String c1 = this.coord1Variable.equals("") ? (this.x1 != 0 || this.y1 != 0 || this.z1 != 0 ? "X%s: " + this.x1 + ", Y%s: " + this.y1 + ", Z%s: " + this.z1 : null) : "XYZ%s: \"" + this.coord1Variable + "\"";
        String c2 = this.coord2Variable.equals("") ? (this.x2 != 0 || this.y2 != 0 || this.z2 != 0 ? "X%s: " + this.x2 + ", Y%s: " + this.y2 + ", Z%s: " + this.z2 : null) : "XYZ%s: \"" + this.coord2Variable + "\"";
        if (c1 == null) {
            c1 = c2;
            c2 = null;
        }
        if (c1 != null) {
            if (c2 != null) {
                curTooltip.add("Contains the points:");
                curTooltip.add(c1.replace("%s", "1"));
                curTooltip.add(c2.replace("%s", "2"));
            } else {
                curTooltip.add("Contains the point:");
                curTooltip.add(c1.replace("%s", "1"));
            }
        }
        this.addAreaTypeTooltip(curTooltip);
    }

    public void addAreaTypeTooltip(List<String> curTooltip) {
        curTooltip.add("Area type: " + this.type.getName());
        ArrayList<AreaType.AreaTypeWidget> widgets = new ArrayList<AreaType.AreaTypeWidget>();
        this.type.addUIWidgets(widgets);
        for (AreaType.AreaTypeWidget widget : widgets) {
            curTooltip.add(String.format("%s %s", I18n.func_135052_a((String)widget.title, (Object[])new Object[0]), widget.getCurValue()));
        }
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.coord1Variable.equals("") && this.coord2Variable.equals("") && this.x1 == 0 && this.y1 == 0 && this.z1 == 0 && this.x2 == 0 && this.y2 == 0 && this.z2 == 0) {
            curInfo.add("gui.progWidget.area.error.noArea");
        }
    }

    public void setP1(BlockPos p) {
        this.x1 = p.func_177958_n();
        this.y1 = p.func_177956_o();
        this.z1 = p.func_177952_p();
    }

    public void setP2(BlockPos p) {
        this.x2 = p.func_177958_n();
        this.y2 = p.func_177956_o();
        this.z2 = p.func_177952_p();
    }

    public void setAreaPoint(BlockPos p, int index) {
        if (index == 0) {
            this.setP1(p);
        } else {
            this.setP2(p);
        }
    }

    public BlockPos getRawAreaPoint(int index) {
        return index == 0 ? new BlockPos(this.x1, this.y1, this.z1) : new BlockPos(this.x2, this.y2, this.z2);
    }

    private BlockPos[] getAreaPoints() {
        BlockPos c2;
        BlockPos c1;
        if (this.coord1Variable.equals("")) {
            c1 = this.x1 != 0 || this.y1 != 0 || this.z1 != 0 ? new BlockPos(this.x1, this.y1, this.z1) : null;
        } else {
            BlockPos blockPos = c1 = this.variableProvider != null ? this.variableProvider.getCoordinate(this.coord1Variable) : null;
        }
        if (this.coord2Variable.equals("")) {
            c2 = this.x2 != 0 || this.y2 != 0 || this.z2 != 0 ? new BlockPos(this.x2, this.y2, this.z2) : null;
        } else {
            BlockPos blockPos = c2 = this.variableProvider != null ? this.variableProvider.getCoordinate(this.coord2Variable) : null;
        }
        if (c1 == null && c2 == null) {
            return new BlockPos[]{null, null};
        }
        if (c1 == null) {
            return new BlockPos[]{c2, null};
        }
        if (c2 == null) {
            return new BlockPos[]{c1, null};
        }
        return new BlockPos[]{c1, c2};
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return ProgWidgetArea.class;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class};
    }

    @Override
    public String getWidgetString() {
        return "area";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_AREA;
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        this.getArea(area, this.type);
    }

    public void getArea(Set<BlockPos> area, AreaType areaType) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null && areaPoints[1] == null) {
            return;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            minY = Math.min(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            minZ = Math.min(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
            maxX = Math.max(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            maxY = Math.max(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            maxZ = Math.max(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
        } else {
            minX = maxX = areaPoints[0].func_177958_n();
            minY = maxY = areaPoints[0].func_177956_o();
            minZ = maxZ = areaPoints[0].func_177952_p();
        }
        int size = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
        if (size > ConfigHandler.general.maxProgrammingArea && this.aiManager != null) {
            IDroneBase drone = this.aiManager.getDrone();
            Log.warning(String.format("Drone @ %s (DIM %d) was killed due to excessively large area (%d > %d). See 'I:maxProgrammingArea' in config.", drone.getDronePos().toString(), drone.world().field_73011_w.getDimension(), size, ConfigHandler.general.maxProgrammingArea));
            drone.overload("areaTooLarge", ConfigHandler.general.maxProgrammingArea);
            return;
        }
        Consumer<BlockPos> addFunc = p -> {
            if (p.func_177956_o() >= 0 && p.func_177956_o() < 256 && area.add((BlockPos)p) && area.size() > ConfigHandler.general.maxProgrammingArea) {
                throw new AreaTooBigException();
            }
        };
        BlockPos p1 = areaPoints[0];
        BlockPos p2 = areaPoints[1] != null ? areaPoints[1] : p1;
        try {
            areaType.addArea(addFunc, p1, p2, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (AreaTooBigException areaTooBigException) {
            // empty catch block
        }
    }

    private AxisAlignedBB getAABB() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return null;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            minY = Math.min(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            minZ = Math.min(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
            maxX = Math.max(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            maxY = Math.max(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            maxZ = Math.max(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
        } else {
            minX = maxX = areaPoints[0].func_177958_n();
            minY = maxY = areaPoints[0].func_177956_o();
            minZ = maxZ = areaPoints[0].func_177952_p();
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    public List<Entity> getEntitiesWithinArea(World world, Predicate<? super Entity> predicate) {
        AxisAlignedBB aabb = this.getAABB();
        return aabb != null ? world.func_175674_a(null, aabb, predicate::test) : new ArrayList<Entity>();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("x1", this.x1);
        tag.func_74768_a("y1", this.y1);
        tag.func_74768_a("z1", this.z1);
        tag.func_74768_a("x2", this.x2);
        tag.func_74768_a("y2", this.y2);
        tag.func_74768_a("z2", this.z2);
        String typeId = typeToIDs.get(this.type.getClass());
        if (typeId == null) {
            Log.error("No type id for area type " + this.type + "! Substituting Box.");
            typeId = "box";
        } else {
            this.type.writeToNBT(tag);
        }
        tag.func_74778_a("type", typeId);
        tag.func_74778_a("coord1Variable", this.coord1Variable);
        tag.func_74778_a("coord2Variable", this.coord2Variable);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.x1 = tag.func_74762_e("x1");
        this.y1 = tag.func_74762_e("y1");
        this.z1 = tag.func_74762_e("z1");
        this.x2 = tag.func_74762_e("x2");
        this.y2 = tag.func_74762_e("y2");
        this.z2 = tag.func_74762_e("z2");
        if (tag.func_74781_a("type") instanceof NBTPrimitive) {
            EnumAreaType oldType = EnumAreaType.values()[tag.func_74762_e("type")];
            int typeInfo = tag.func_74762_e("typeInfo");
            this.type = ProgWidgetArea.convertFromLegacyFormat(oldType, typeInfo);
        } else {
            this.type = ProgWidgetArea.createType(tag.func_74779_i("type"));
            this.type.readFromNBT(tag);
        }
        this.coord1Variable = tag.func_74779_i("coord1Variable");
        this.coord2Variable = tag.func_74779_i("coord2Variable");
    }

    private static AreaType createType(String id) {
        Supplier<? extends AreaType> creator = areaTypes.get(id);
        if (creator != null) {
            return creator.get();
        }
        Log.error("No Area type found for id '" + id + "'! Substituting Box!");
        return new AreaTypeBox();
    }

    @Deprecated
    public static AreaType convertFromLegacyFormat(EnumAreaType oldType, int typeInfo) {
        String newTypeId = oldFormatToAreaTypes.get((Object)oldType);
        if (newTypeId == null) {
            Log.error("No area converter found for EnumAreaType " + (Object)((Object)oldType) + "! Substituting Box.");
            return new AreaTypeBox();
        }
        AreaType type = ProgWidgetArea.createType(newTypeId);
        type.convertFromLegacy(oldType, typeInfo);
        return type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetArea(this, guiProgrammer);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public int getCraftingColorIndex() {
        return 2;
    }

    public String getCoord1Variable() {
        return this.coord1Variable;
    }

    public void setCoord1Variable(String coord1Variable) {
        this.coord1Variable = coord1Variable;
    }

    public String getCoord2Variable() {
        return this.coord2Variable;
    }

    public void setCoord2Variable(String coord2Variable) {
        this.coord2Variable = coord2Variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
        this.variableProvider = aiManager;
    }

    public void setVariableProvider(IVariableProvider variableProvider) {
        this.variableProvider = variableProvider;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.coord1Variable);
        variables.add(this.coord2Variable);
    }

    static {
        ProgWidgetArea.register("box", AreaTypeBox.class, AreaTypeBox::new, EnumAreaType.FILL, EnumAreaType.WALL, EnumAreaType.FRAME);
        ProgWidgetArea.register("sphere", AreaTypeSphere.class, AreaTypeSphere::new, EnumAreaType.SPHERE);
        ProgWidgetArea.register("line", AreaTypeLine.class, AreaTypeLine::new, EnumAreaType.LINE);
        ProgWidgetArea.register("wall", AreaTypeWall.class, AreaTypeWall::new, EnumAreaType.X_WALL, EnumAreaType.Y_WALL, EnumAreaType.Z_WALL);
        ProgWidgetArea.register("cylinder", AreaTypeCylinder.class, AreaTypeCylinder::new, EnumAreaType.X_CYLINDER, EnumAreaType.Y_CYLINDER, EnumAreaType.Z_CYLINDER);
        ProgWidgetArea.register("pyramid", AreaTypePyramid.class, AreaTypePyramid::new, EnumAreaType.X_PYRAMID, EnumAreaType.Y_PYRAMID, EnumAreaType.Z_PYRAMID);
        ProgWidgetArea.register("grid", AreaTypeGrid.class, AreaTypeGrid::new, EnumAreaType.GRID);
        ProgWidgetArea.register("random", AreaTypeRandom.class, AreaTypeRandom::new, EnumAreaType.RANDOM);
        if (oldFormatToAreaTypes.size() != EnumAreaType.values().length) {
            throw new IllegalStateException("Not all old formats are handled!");
        }
    }

    @Deprecated
    public static enum EnumAreaType {
        FILL("Filled"),
        FRAME("Frame"),
        WALL("Walls"),
        SPHERE("Sphere"),
        LINE("Line"),
        X_WALL("X-Wall"),
        Y_WALL("Y-Wall"),
        Z_WALL("Z-Wall"),
        X_CYLINDER("X-Cylinder"),
        Y_CYLINDER("Y-Cylinder"),
        Z_CYLINDER("Z-Cylinder"),
        X_PYRAMID("X-Pyramid"),
        Y_PYRAMID("Y-Pyramid"),
        Z_PYRAMID("Z-Pyramid"),
        GRID("Grid", true),
        RANDOM("Random", true);

        private final String name;
        public final boolean utilizesTypeInfo;

        private EnumAreaType(String name) {
            this(name, false);
        }

        private EnumAreaType(String name, boolean utilizesTypeInfo) {
            this.name = name;
            this.utilizesTypeInfo = utilizesTypeInfo;
        }

        public String toString() {
            return this.name;
        }
    }
}

