/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetPlace;
import me.desht.pneumaticcraft.common.ai.DroneAIPlace;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetPlace
extends ProgWidgetDigAndPlace
implements ISidedWidget {
    public EnumFacing placeDir = EnumFacing.DOWN;

    public ProgWidgetPlace() {
        super(IBlockOrdered.EnumOrder.LOW_TO_HIGH);
    }

    @Override
    public void setSides(boolean[] sides) {
        this.placeDir = ProgWidgetPlace.getDirForSides(sides);
    }

    @Override
    public boolean[] getSides() {
        return ProgWidgetPlace.getSidesFromDir(this.placeDir);
    }

    public static EnumFacing getDirForSides(boolean[] sides) {
        for (int i = 0; i < sides.length; ++i) {
            if (!sides[i]) continue;
            return EnumFacing.func_82600_a((int)i);
        }
        Log.error("[ProgWidgetPlace] Sides boolean array empty!");
        return EnumFacing.DOWN;
    }

    public static boolean[] getSidesFromDir(EnumFacing dir) {
        boolean[] dirs = new boolean[6];
        dirs[dir.ordinal()] = true;
        return dirs;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Placing direction: " + PneumaticCraftUtils.getOrientationName(this.placeDir));
    }

    @Override
    public String getWidgetString() {
        return "place";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_PLACE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetPlace<ProgWidgetPlace>(this, guiProgrammer);
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIPlace(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("dir", this.placeDir.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.placeDir = EnumFacing.func_82600_a((int)tag.func_74762_e("dir"));
    }

    @Override
    public int getCraftingColorIndex() {
        return 11;
    }
}

