/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.thirdparty.IHeatDisperser;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.MekanismHeatAdapter;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.TileEntityCache;
import mekanism.api.IHeatTransfer;
import mekanism.api.transmitters.IGridTransmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class Mekanism
implements IThirdParty,
IHeatDisperser {
    @CapabilityInject(value=IHeatTransfer.class)
    public static Capability<IHeatTransfer> CAPABILITY_HEAT_TRANSFER = null;
    @CapabilityInject(value=IGridTransmitter.class)
    public static Capability<IGridTransmitter> CAPABILITY_GRID_TRANSMITTER = null;
    private static MekanismHeatAdapter adapter = null;
    public static boolean available = false;

    @Override
    public void preInit() {
        available = true;
        TileEntityBase.registerHeatDisperser(this);
    }

    @Override
    public void disperseHeat(TileEntity te, TileEntityCache[] tileCache) {
        IHeatTransfer source = (IHeatTransfer)te.getCapability(CAPABILITY_HEAT_TRANSFER, null);
        if (source != null) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                IHeatTransfer sink;
                if (tileCache[side.func_176745_a()].getTileEntity() instanceof TileEntityBase || (sink = source.getAdjacent(side)) == null || !(source.getTemp() > sink.getTemp() + 300.0)) continue;
                double invConduction = sink.getInverseConductionCoefficient() + source.getInverseConductionCoefficient();
                double heatToTransfer = (source.getTemp() - (sink.getTemp() + 300.0)) / invConduction;
                source.transferHeatTo(-heatToTransfer);
                sink.transferHeatTo(heatToTransfer * ConfigHandler.integration.mekHeatEfficiency);
            }
        }
    }

    public static IHeatTransfer getHeatAdapter(TileEntityBase te, EnumFacing side) {
        if (adapter == null) {
            adapter = new MekanismHeatAdapter();
        }
        if (te instanceof IHeatExchanger) {
            return adapter.setup(te, side);
        }
        return null;
    }
}

