/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.output;

import ic2.api.classic.tile.IStackOutput;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.util.misc.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SimpleStackOutput
implements IStackOutput {
    ItemStack stack;
    int outputSlot;

    public SimpleStackOutput(ItemStack output, int slot) {
        this.stack = output;
        this.outputSlot = slot;
    }

    public SimpleStackOutput(NBTTagCompound nbt) {
        this(new ItemStack(nbt.func_74775_l("Item")), nbt.func_74762_e("Slot"));
    }

    @Override
    public boolean addToInventory(IHasInventory inventory) {
        if (this.stack.func_190926_b()) {
            return true;
        }
        if (inventory.getStackInSlot(this.outputSlot).func_190926_b()) {
            inventory.setStackInSlot(this.outputSlot, this.stack.func_77946_l());
            return true;
        }
        if (!StackUtil.isStackEqual(inventory.getStackInSlot(this.outputSlot), this.stack, false, false)) {
            return false;
        }
        int left = inventory.getStackInSlot(this.outputSlot).func_77976_d() - inventory.getStackInSlot(this.outputSlot).func_190916_E();
        if (left <= 0) {
            return false;
        }
        if (left >= this.stack.func_190916_E()) {
            inventory.getStackInSlot(this.outputSlot).func_190917_f(this.stack.func_190916_E());
            return true;
        }
        int itemLeft = this.stack.func_190916_E() - left;
        this.stack.func_190920_e(itemLeft);
        inventory.getStackInSlot(this.outputSlot).func_190920_e(inventory.getStackInSlot(this.outputSlot).func_77976_d());
        return false;
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Slot", this.outputSlot);
        nbt.func_74782_a("Item", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public String getID() {
        return "Simple Output";
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }
}

