/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.reactor.IReactorChamber;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityNuclearReactorBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityNuclearReactorElectric
extends TileEntityNuclearReactorBase
implements IEnergySource,
IMetaDelegate {
    public static float configMod;
    public boolean markedRefreshed = false;
    public boolean addedToEnet = false;
    List<IEnergyTile> subTiles;

    public TileEntityNuclearReactorElectric() {
        configMod = IC2.config.getFloat("energyGeneratorNuclear");
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.nuclearReactor;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return super.getReactorEUEnergyOutput() * (double)configMod;
    }

    @Override
    public double getOfferedEnergy() {
        return this.getReactorEUEnergyOutput();
    }

    @Override
    public void drawEnergy(double amount) {
    }

    @Override
    public int getSourceTier() {
        return EnergyNet.instance.getTierFromPower(this.output);
    }

    @Override
    public void func_73660_a() {
        if (this.markedRefreshed) {
            this.markedRefreshed = false;
            if (this.addedToEnet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.subTiles = null;
            if (this.addedToEnet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
        }
        super.func_73660_a();
    }

    @Override
    public List<IEnergyTile> getSubTiles() {
        if (this.subTiles != null) {
            return this.subTiles;
        }
        this.subTiles = new ArrayList<IEnergyTile>();
        this.subTiles.add(this);
        for (Direction dir : Direction.directions) {
            TileEntity te = dir.applyToTileEntity(this);
            if (!(te instanceof IReactorChamber) || !(te instanceof IEnergyTile)) continue;
            this.subTiles.add((IEnergyTile)te);
        }
        return this.subTiles;
    }

    @Override
    public void refreshChambers() {
        super.refreshChambers();
        this.markedRefreshed = true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void issueAchievement(EntityPlayer player) {
        IC2.achievements.issueStat(player, "nuclearReactorsExploded");
    }
}

