/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.personal.base.misc.IOwnerBlock;
import ic2.core.inventory.base.IHasGui;
import ic2.core.platform.player.TeamManager;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public abstract class TileEntityPersonalStorageBase
extends TileEntityBlock
implements INetworkClientTileEntityEventListener,
IOwnerBlock,
IHasGui {
    @NetworkField(index=3)
    public boolean allowView = false;
    @NetworkField(index=4)
    public boolean allowInjection = false;
    @NetworkField(index=5)
    public boolean allowExtraction = false;
    @NetworkField(index=6)
    public UUID owner;
    @NetworkField(index=7)
    public boolean allowTeam = false;

    public TileEntityPersonalStorageBase() {
        this.addNetworkFields("owner", "allowView", "allowInjection", "allowExtraction", "allowTeam");
    }

    public abstract boolean allowExtraction();

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (!this.canAccess(player.func_110124_au())) {
            return;
        }
        if (event == 0) {
            this.allowView = !this.allowView;
            this.getNetwork().updateTileEntityField(this, "allowView");
        } else if (event == 2) {
            this.allowInjection = !this.allowInjection;
            this.getNetwork().updateTileEntityField(this, "allowInjection");
        } else if (event == 3) {
            this.allowExtraction = !this.allowExtraction;
            this.getNetwork().updateTileEntityField(this, "allowExtraction");
        } else if (event == 4) {
            this.allowTeam = !this.allowTeam;
            this.getNetwork().updateTileEntityField(this, "allowTeam");
        }
        this.onChange(event);
        if (event == 1) {
            player.field_71070_bA.func_75142_b();
        }
    }

    public void onChange(int type) {
    }

    @Override
    public void setOwner(UUID user) {
        if (this.owner == null && user != null) {
            this.owner = user;
        }
    }

    @Override
    public boolean canAccess(UUID user) {
        if (this.owner == null) {
            this.setOwner(user);
            return true;
        }
        if (this.owner.equals(user)) {
            return true;
        }
        if (IC2.platform.isOp(user)) {
            return true;
        }
        if (this.allowTeam) {
            return TeamManager.instance.isSameTeam(this.owner, user);
        }
        return false;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return (this.canAccess(player.func_110124_au()) || this.allowView) && !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return this.canAccess(player.func_110124_au()) || this.allowView;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.allowView = nbt.func_74767_n("Show");
        this.allowInjection = nbt.func_74767_n("Inject");
        this.allowExtraction = nbt.func_74767_n("Extract");
        this.allowTeam = nbt.func_74767_n("AllowTeam");
        if (nbt.func_186855_b("Owner")) {
            this.owner = nbt.func_186857_a("Owner");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Show", this.allowView);
        nbt.func_74757_a("Inject", this.allowInjection);
        nbt.func_74757_a("Extract", this.allowExtraction);
        nbt.func_74757_a("AllowTeam", this.allowTeam);
        if (this.owner != null) {
            nbt.func_186854_a("Owner", this.owner);
        }
        return nbt;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return this.canAccess(player.func_110124_au());
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        if (!this.canAccess(player.func_110124_au())) {
            return false;
        }
        return facing != this.getFacing();
    }

    public void loadFromState(int state) {
        if (state == 3) {
            this.allowExtraction = true;
            this.allowInjection = true;
        } else if (state == 2) {
            this.allowInjection = true;
            this.allowExtraction = false;
        } else if (state == 1) {
            this.allowExtraction = true;
            this.allowInjection = false;
        } else {
            this.allowExtraction = false;
            this.allowInjection = false;
        }
    }

    public int getValue() {
        int value = 0;
        if (this.allowExtraction) {
            ++value;
        }
        if (this.allowInjection) {
            value += 2;
        }
        return value;
    }
}

